/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreatePolicyVersion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePolicyVersionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreatePolicyVersionRequest.Builder, CreatePolicyVersionRequest> {
    private final String policyName;

    private final String policyDocument;

    private final Boolean setAsDefault;

    private CreatePolicyVersionRequest(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.setAsDefault = builder.setAsDefault;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding whitespaces
     * </p>
     * 
     * @return The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding
     *         whitespaces
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * Specifies whether the policy version is set as the default. When this parameter is true, the new policy version
     * becomes the operative version (that is, the version that is in effect for the certificates to which the policy is
     * attached).
     * </p>
     * 
     * @return Specifies whether the policy version is set as the default. When this parameter is true, the new policy
     *         version becomes the operative version (that is, the version that is in effect for the certificates to
     *         which the policy is attached).
     */
    public Boolean setAsDefault() {
        return setAsDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policyDocument() == null) ? 0 : policyDocument().hashCode());
        hashCode = 31 * hashCode + ((setAsDefault() == null) ? 0 : setAsDefault().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionRequest)) {
            return false;
        }
        CreatePolicyVersionRequest other = (CreatePolicyVersionRequest) obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.setAsDefault() == null ^ this.setAsDefault() == null) {
            return false;
        }
        if (other.setAsDefault() != null && !other.setAsDefault().equals(this.setAsDefault())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (setAsDefault() != null) {
            sb.append("SetAsDefault: ").append(setAsDefault()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "setAsDefault":
            return Optional.of(clazz.cast(setAsDefault()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreatePolicyVersionRequest> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding
         * whitespaces
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy. Minimum length of 1. Maximum length of 2048, excluding
         *        whitespaces
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * Specifies whether the policy version is set as the default. When this parameter is true, the new policy
         * version becomes the operative version (that is, the version that is in effect for the certificates to which
         * the policy is attached).
         * </p>
         * 
         * @param setAsDefault
         *        Specifies whether the policy version is set as the default. When this parameter is true, the new
         *        policy version becomes the operative version (that is, the version that is in effect for the
         *        certificates to which the policy is attached).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsDefault(Boolean setAsDefault);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private Boolean setAsDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionRequest model) {
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            setAsDefault(model.setAsDefault);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Boolean getSetAsDefault() {
            return setAsDefault;
        }

        @Override
        public final Builder setAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
            return this;
        }

        public final void setSetAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
        }

        @Override
        public CreatePolicyVersionRequest build() {
            return new CreatePolicyVersionRequest(this);
        }
    }
}
