/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateTopicRule operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTopicRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateTopicRuleRequest.Builder, CreateTopicRuleRequest> {
    private final String ruleName;

    private final TopicRulePayload topicRulePayload;

    private CreateTopicRuleRequest(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.topicRulePayload = builder.topicRulePayload;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The rule payload.
     * </p>
     * 
     * @return The rule payload.
     */
    public TopicRulePayload topicRulePayload() {
        return topicRulePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleName() == null) ? 0 : ruleName().hashCode());
        hashCode = 31 * hashCode + ((topicRulePayload() == null) ? 0 : topicRulePayload().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleRequest)) {
            return false;
        }
        CreateTopicRuleRequest other = (CreateTopicRuleRequest) obj;
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        if (other.topicRulePayload() == null ^ this.topicRulePayload() == null) {
            return false;
        }
        if (other.topicRulePayload() != null && !other.topicRulePayload().equals(this.topicRulePayload())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        if (topicRulePayload() != null) {
            sb.append("TopicRulePayload: ").append(topicRulePayload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.of(clazz.cast(ruleName()));
        case "topicRulePayload":
            return Optional.of(clazz.cast(topicRulePayload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTopicRuleRequest> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The rule payload.
         * </p>
         * 
         * @param topicRulePayload
         *        The rule payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicRulePayload(TopicRulePayload topicRulePayload);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private TopicRulePayload topicRulePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleRequest model) {
            ruleName(model.ruleName);
            topicRulePayload(model.topicRulePayload);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final TopicRulePayload.Builder getTopicRulePayload() {
            return topicRulePayload != null ? topicRulePayload.toBuilder() : null;
        }

        @Override
        public final Builder topicRulePayload(TopicRulePayload topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        public final void setTopicRulePayload(TopicRulePayload.BuilderImpl topicRulePayload) {
            this.topicRulePayload = topicRulePayload != null ? topicRulePayload.build() : null;
        }

        @Override
        public CreateTopicRuleRequest build() {
            return new CreateTopicRuleRequest(this);
        }
    }
}
