/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DeprecateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeprecateThingTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeprecateThingTypeRequest.Builder, DeprecateThingTypeRequest> {
    private final String thingTypeName;

    private final Boolean undoDeprecate;

    private DeprecateThingTypeRequest(BuilderImpl builder) {
        this.thingTypeName = builder.thingTypeName;
        this.undoDeprecate = builder.undoDeprecate;
    }

    /**
     * <p>
     * The name of the thing type to deprecate.
     * </p>
     * 
     * @return The name of the thing type to deprecate.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore and
     * you can associate it with things.
     * </p>
     * 
     * @return Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated
     *         anymore and you can associate it with things.
     */
    public Boolean undoDeprecate() {
        return undoDeprecate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        hashCode = 31 * hashCode + ((undoDeprecate() == null) ? 0 : undoDeprecate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeprecateThingTypeRequest)) {
            return false;
        }
        DeprecateThingTypeRequest other = (DeprecateThingTypeRequest) obj;
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.undoDeprecate() == null ^ this.undoDeprecate() == null) {
            return false;
        }
        if (other.undoDeprecate() != null && !other.undoDeprecate().equals(this.undoDeprecate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (undoDeprecate() != null) {
            sb.append("UndoDeprecate: ").append(undoDeprecate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "undoDeprecate":
            return Optional.of(clazz.cast(undoDeprecate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeprecateThingTypeRequest> {
        /**
         * <p>
         * The name of the thing type to deprecate.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type to deprecate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated anymore
         * and you can associate it with things.
         * </p>
         * 
         * @param undoDeprecate
         *        Whether to undeprecate a deprecated thing type. If <b>true</b>, the thing type will not be deprecated
         *        anymore and you can associate it with things.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder undoDeprecate(Boolean undoDeprecate);
    }

    static final class BuilderImpl implements Builder {
        private String thingTypeName;

        private Boolean undoDeprecate;

        private BuilderImpl() {
        }

        private BuilderImpl(DeprecateThingTypeRequest model) {
            thingTypeName(model.thingTypeName);
            undoDeprecate(model.undoDeprecate);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Boolean getUndoDeprecate() {
            return undoDeprecate;
        }

        @Override
        public final Builder undoDeprecate(Boolean undoDeprecate) {
            this.undoDeprecate = undoDeprecate;
            return this;
        }

        public final void setUndoDeprecate(Boolean undoDeprecate) {
            this.undoDeprecate = undoDeprecate;
        }

        @Override
        public DeprecateThingTypeRequest build() {
            return new DeprecateThingTypeRequest(this);
        }
    }
}
