/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DetachPrincipalPolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachPrincipalPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetachPrincipalPolicyRequest.Builder, DetachPrincipalPolicyRequest> {
    private final String policyName;

    private final String principal;

    private DetachPrincipalPolicyRequest(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The name of the policy to detach.
     * </p>
     * 
     * @return The name of the policy to detach.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The principal.
     * </p>
     * <p>
     * If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito identity,
     * specify the identity ID.
     * </p>
     * 
     * @return The principal.</p>
     *         <p>
     *         If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito
     *         identity, specify the identity ID.
     */
    public String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((principal() == null) ? 0 : principal().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachPrincipalPolicyRequest)) {
            return false;
        }
        DetachPrincipalPolicyRequest other = (DetachPrincipalPolicyRequest) obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.principal() == null ^ this.principal() == null) {
            return false;
        }
        if (other.principal() != null && !other.principal().equals(this.principal())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (principal() != null) {
            sb.append("Principal: ").append(principal()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        case "principal":
            return Optional.of(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DetachPrincipalPolicyRequest> {
        /**
         * <p>
         * The name of the policy to detach.
         * </p>
         * 
         * @param policyName
         *        The name of the policy to detach.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The principal.
         * </p>
         * <p>
         * If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito
         * identity, specify the identity ID.
         * </p>
         * 
         * @param principal
         *        The principal.</p>
         *        <p>
         *        If the principal is a certificate, specify the certificate ARN. If the principal is an Amazon Cognito
         *        identity, specify the identity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachPrincipalPolicyRequest model) {
            policyName(model.policyName);
            principal(model.principal);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public DetachPrincipalPolicyRequest build() {
            return new DetachPrincipalPolicyRequest(this);
        }
    }
}
