/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.DynamoDBActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write to a DynamoDB table.
 * </p>
 * <p>
 * The <code>tableName</code>, <code>hashKeyField</code>, and <code>rangeKeyField</code> values must match the values
 * used when you created the table.
 * </p>
 * <p>
 * The <code>hashKeyValue</code> and <code>rangeKeyvalue</code> fields use a substitution template syntax. These
 * templates provide data at runtime. The syntax is as follows: ${<i>sql-expression</i>}.
 * </p>
 * <p>
 * You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons,
 * calculations, and functions. For example, the following field uses the third level of the topic:
 * </p>
 * <p>
 * <code>"hashKeyValue": "${topic(3)}"</code>
 * </p>
 * <p>
 * The following field uses the timestamp:
 * </p>
 * <p>
 * <code>"rangeKeyValue": "${timestamp()}"</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DynamoDBAction implements StructuredPojo, ToCopyableBuilder<DynamoDBAction.Builder, DynamoDBAction> {
    private final String tableName;

    private final String roleArn;

    private final String operation;

    private final String hashKeyField;

    private final String hashKeyValue;

    private final String hashKeyType;

    private final String rangeKeyField;

    private final String rangeKeyValue;

    private final String rangeKeyType;

    private final String payloadField;

    private DynamoDBAction(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.operation = builder.operation;
        this.hashKeyField = builder.hashKeyField;
        this.hashKeyValue = builder.hashKeyValue;
        this.hashKeyType = builder.hashKeyType;
        this.rangeKeyField = builder.rangeKeyField;
        this.rangeKeyValue = builder.rangeKeyValue;
        this.rangeKeyType = builder.rangeKeyType;
        this.payloadField = builder.payloadField;
    }

    /**
     * <p>
     * The name of the DynamoDB table.
     * </p>
     * 
     * @return The name of the DynamoDB table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the DynamoDB table.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the DynamoDB table.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The type of operation to be performed. This follows the substitution template, so it can be
     * <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>,
     * <code>UPDATE</code>, or <code>DELETE</code>.
     * </p>
     * 
     * @return The type of operation to be performed. This follows the substitution template, so it can be
     *         <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>,
     *         <code>UPDATE</code>, or <code>DELETE</code>.
     */
    public String operation() {
        return operation;
    }

    /**
     * <p>
     * The hash key name.
     * </p>
     * 
     * @return The hash key name.
     */
    public String hashKeyField() {
        return hashKeyField;
    }

    /**
     * <p>
     * The hash key value.
     * </p>
     * 
     * @return The hash key value.
     */
    public String hashKeyValue() {
        return hashKeyValue;
    }

    /**
     * <p>
     * The hash key type. Valid values are "STRING" or "NUMBER"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashKeyType} will
     * return {@link DynamoKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashKeyTypeString}.
     * </p>
     * 
     * @return The hash key type. Valid values are "STRING" or "NUMBER"
     * @see DynamoKeyType
     */
    public DynamoKeyType hashKeyType() {
        return DynamoKeyType.fromValue(hashKeyType);
    }

    /**
     * <p>
     * The hash key type. Valid values are "STRING" or "NUMBER"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hashKeyType} will
     * return {@link DynamoKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hashKeyTypeString}.
     * </p>
     * 
     * @return The hash key type. Valid values are "STRING" or "NUMBER"
     * @see DynamoKeyType
     */
    public String hashKeyTypeString() {
        return hashKeyType;
    }

    /**
     * <p>
     * The range key name.
     * </p>
     * 
     * @return The range key name.
     */
    public String rangeKeyField() {
        return rangeKeyField;
    }

    /**
     * <p>
     * The range key value.
     * </p>
     * 
     * @return The range key value.
     */
    public String rangeKeyValue() {
        return rangeKeyValue;
    }

    /**
     * <p>
     * The range key type. Valid values are "STRING" or "NUMBER"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rangeKeyType} will
     * return {@link DynamoKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rangeKeyTypeString}.
     * </p>
     * 
     * @return The range key type. Valid values are "STRING" or "NUMBER"
     * @see DynamoKeyType
     */
    public DynamoKeyType rangeKeyType() {
        return DynamoKeyType.fromValue(rangeKeyType);
    }

    /**
     * <p>
     * The range key type. Valid values are "STRING" or "NUMBER"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rangeKeyType} will
     * return {@link DynamoKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rangeKeyTypeString}.
     * </p>
     * 
     * @return The range key type. Valid values are "STRING" or "NUMBER"
     * @see DynamoKeyType
     */
    public String rangeKeyTypeString() {
        return rangeKeyType;
    }

    /**
     * <p>
     * The action payload. This name can be customized.
     * </p>
     * 
     * @return The action payload. This name can be customized.
     */
    public String payloadField() {
        return payloadField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((operation() == null) ? 0 : operation().hashCode());
        hashCode = 31 * hashCode + ((hashKeyField() == null) ? 0 : hashKeyField().hashCode());
        hashCode = 31 * hashCode + ((hashKeyValue() == null) ? 0 : hashKeyValue().hashCode());
        hashCode = 31 * hashCode + ((hashKeyTypeString() == null) ? 0 : hashKeyTypeString().hashCode());
        hashCode = 31 * hashCode + ((rangeKeyField() == null) ? 0 : rangeKeyField().hashCode());
        hashCode = 31 * hashCode + ((rangeKeyValue() == null) ? 0 : rangeKeyValue().hashCode());
        hashCode = 31 * hashCode + ((rangeKeyTypeString() == null) ? 0 : rangeKeyTypeString().hashCode());
        hashCode = 31 * hashCode + ((payloadField() == null) ? 0 : payloadField().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBAction)) {
            return false;
        }
        DynamoDBAction other = (DynamoDBAction) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.operation() == null ^ this.operation() == null) {
            return false;
        }
        if (other.operation() != null && !other.operation().equals(this.operation())) {
            return false;
        }
        if (other.hashKeyField() == null ^ this.hashKeyField() == null) {
            return false;
        }
        if (other.hashKeyField() != null && !other.hashKeyField().equals(this.hashKeyField())) {
            return false;
        }
        if (other.hashKeyValue() == null ^ this.hashKeyValue() == null) {
            return false;
        }
        if (other.hashKeyValue() != null && !other.hashKeyValue().equals(this.hashKeyValue())) {
            return false;
        }
        if (other.hashKeyTypeString() == null ^ this.hashKeyTypeString() == null) {
            return false;
        }
        if (other.hashKeyTypeString() != null && !other.hashKeyTypeString().equals(this.hashKeyTypeString())) {
            return false;
        }
        if (other.rangeKeyField() == null ^ this.rangeKeyField() == null) {
            return false;
        }
        if (other.rangeKeyField() != null && !other.rangeKeyField().equals(this.rangeKeyField())) {
            return false;
        }
        if (other.rangeKeyValue() == null ^ this.rangeKeyValue() == null) {
            return false;
        }
        if (other.rangeKeyValue() != null && !other.rangeKeyValue().equals(this.rangeKeyValue())) {
            return false;
        }
        if (other.rangeKeyTypeString() == null ^ this.rangeKeyTypeString() == null) {
            return false;
        }
        if (other.rangeKeyTypeString() != null && !other.rangeKeyTypeString().equals(this.rangeKeyTypeString())) {
            return false;
        }
        if (other.payloadField() == null ^ this.payloadField() == null) {
            return false;
        }
        if (other.payloadField() != null && !other.payloadField().equals(this.payloadField())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (operation() != null) {
            sb.append("Operation: ").append(operation()).append(",");
        }
        if (hashKeyField() != null) {
            sb.append("HashKeyField: ").append(hashKeyField()).append(",");
        }
        if (hashKeyValue() != null) {
            sb.append("HashKeyValue: ").append(hashKeyValue()).append(",");
        }
        if (hashKeyTypeString() != null) {
            sb.append("HashKeyType: ").append(hashKeyTypeString()).append(",");
        }
        if (rangeKeyField() != null) {
            sb.append("RangeKeyField: ").append(rangeKeyField()).append(",");
        }
        if (rangeKeyValue() != null) {
            sb.append("RangeKeyValue: ").append(rangeKeyValue()).append(",");
        }
        if (rangeKeyTypeString() != null) {
            sb.append("RangeKeyType: ").append(rangeKeyTypeString()).append(",");
        }
        if (payloadField() != null) {
            sb.append("PayloadField: ").append(payloadField()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableName":
            return Optional.of(clazz.cast(tableName()));
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "operation":
            return Optional.of(clazz.cast(operation()));
        case "hashKeyField":
            return Optional.of(clazz.cast(hashKeyField()));
        case "hashKeyValue":
            return Optional.of(clazz.cast(hashKeyValue()));
        case "hashKeyType":
            return Optional.of(clazz.cast(hashKeyTypeString()));
        case "rangeKeyField":
            return Optional.of(clazz.cast(rangeKeyField()));
        case "rangeKeyValue":
            return Optional.of(clazz.cast(rangeKeyValue()));
        case "rangeKeyType":
            return Optional.of(clazz.cast(rangeKeyTypeString()));
        case "payloadField":
            return Optional.of(clazz.cast(payloadField()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DynamoDBAction> {
        /**
         * <p>
         * The name of the DynamoDB table.
         * </p>
         * 
         * @param tableName
         *        The name of the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The type of operation to be performed. This follows the substitution template, so it can be
         * <code>${operation}</code>, but the substitution must result in one of the following: <code>INSERT</code>,
         * <code>UPDATE</code>, or <code>DELETE</code>.
         * </p>
         * 
         * @param operation
         *        The type of operation to be performed. This follows the substitution template, so it can be
         *        <code>${operation}</code>, but the substitution must result in one of the following:
         *        <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The hash key name.
         * </p>
         * 
         * @param hashKeyField
         *        The hash key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashKeyField(String hashKeyField);

        /**
         * <p>
         * The hash key value.
         * </p>
         * 
         * @param hashKeyValue
         *        The hash key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashKeyValue(String hashKeyValue);

        /**
         * <p>
         * The hash key type. Valid values are "STRING" or "NUMBER"
         * </p>
         * 
         * @param hashKeyType
         *        The hash key type. Valid values are "STRING" or "NUMBER"
         * @see DynamoKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamoKeyType
         */
        Builder hashKeyType(String hashKeyType);

        /**
         * <p>
         * The hash key type. Valid values are "STRING" or "NUMBER"
         * </p>
         * 
         * @param hashKeyType
         *        The hash key type. Valid values are "STRING" or "NUMBER"
         * @see DynamoKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamoKeyType
         */
        Builder hashKeyType(DynamoKeyType hashKeyType);

        /**
         * <p>
         * The range key name.
         * </p>
         * 
         * @param rangeKeyField
         *        The range key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeKeyField(String rangeKeyField);

        /**
         * <p>
         * The range key value.
         * </p>
         * 
         * @param rangeKeyValue
         *        The range key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeKeyValue(String rangeKeyValue);

        /**
         * <p>
         * The range key type. Valid values are "STRING" or "NUMBER"
         * </p>
         * 
         * @param rangeKeyType
         *        The range key type. Valid values are "STRING" or "NUMBER"
         * @see DynamoKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamoKeyType
         */
        Builder rangeKeyType(String rangeKeyType);

        /**
         * <p>
         * The range key type. Valid values are "STRING" or "NUMBER"
         * </p>
         * 
         * @param rangeKeyType
         *        The range key type. Valid values are "STRING" or "NUMBER"
         * @see DynamoKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DynamoKeyType
         */
        Builder rangeKeyType(DynamoKeyType rangeKeyType);

        /**
         * <p>
         * The action payload. This name can be customized.
         * </p>
         * 
         * @param payloadField
         *        The action payload. This name can be customized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadField(String payloadField);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String roleArn;

        private String operation;

        private String hashKeyField;

        private String hashKeyValue;

        private String hashKeyType;

        private String rangeKeyField;

        private String rangeKeyValue;

        private String rangeKeyType;

        private String payloadField;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBAction model) {
            tableName(model.tableName);
            roleArn(model.roleArn);
            operation(model.operation);
            hashKeyField(model.hashKeyField);
            hashKeyValue(model.hashKeyValue);
            hashKeyType(model.hashKeyType);
            rangeKeyField(model.rangeKeyField);
            rangeKeyValue(model.rangeKeyValue);
            rangeKeyType(model.rangeKeyType);
            payloadField(model.payloadField);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getHashKeyField() {
            return hashKeyField;
        }

        @Override
        public final Builder hashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
            return this;
        }

        public final void setHashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
        }

        public final String getHashKeyValue() {
            return hashKeyValue;
        }

        @Override
        public final Builder hashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        public final void setHashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
        }

        public final String getHashKeyType() {
            return hashKeyType;
        }

        @Override
        public final Builder hashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
            return this;
        }

        @Override
        public final Builder hashKeyType(DynamoKeyType hashKeyType) {
            this.hashKeyType(hashKeyType.toString());
            return this;
        }

        public final void setHashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
        }

        public final String getRangeKeyField() {
            return rangeKeyField;
        }

        @Override
        public final Builder rangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
            return this;
        }

        public final void setRangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
        }

        public final String getRangeKeyValue() {
            return rangeKeyValue;
        }

        @Override
        public final Builder rangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        public final void setRangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
        }

        public final String getRangeKeyType() {
            return rangeKeyType;
        }

        @Override
        public final Builder rangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
            return this;
        }

        @Override
        public final Builder rangeKeyType(DynamoKeyType rangeKeyType) {
            this.rangeKeyType(rangeKeyType.toString());
            return this;
        }

        public final void setRangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
        }

        public final String getPayloadField() {
            return payloadField;
        }

        @Override
        public final Builder payloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public final void setPayloadField(String payloadField) {
            this.payloadField = payloadField;
        }

        @Override
        public DynamoDBAction build() {
            return new DynamoDBAction(this);
        }
    }
}
