/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetRegistrationCode operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRegistrationCodeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetRegistrationCodeResponse.Builder, GetRegistrationCodeResponse> {
    private final String registrationCode;

    private GetRegistrationCodeResponse(BuilderImpl builder) {
        this.registrationCode = builder.registrationCode;
    }

    /**
     * <p>
     * The CA certificate registration code.
     * </p>
     * 
     * @return The CA certificate registration code.
     */
    public String registrationCode() {
        return registrationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((registrationCode() == null) ? 0 : registrationCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistrationCodeResponse)) {
            return false;
        }
        GetRegistrationCodeResponse other = (GetRegistrationCodeResponse) obj;
        if (other.registrationCode() == null ^ this.registrationCode() == null) {
            return false;
        }
        if (other.registrationCode() != null && !other.registrationCode().equals(this.registrationCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (registrationCode() != null) {
            sb.append("RegistrationCode: ").append(registrationCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registrationCode":
            return Optional.of(clazz.cast(registrationCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetRegistrationCodeResponse> {
        /**
         * <p>
         * The CA certificate registration code.
         * </p>
         * 
         * @param registrationCode
         *        The CA certificate registration code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationCode(String registrationCode);
    }

    static final class BuilderImpl implements Builder {
        private String registrationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistrationCodeResponse model) {
            registrationCode(model.registrationCode);
        }

        public final String getRegistrationCode() {
            return registrationCode;
        }

        @Override
        public final Builder registrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
            return this;
        }

        public final void setRegistrationCode(String registrationCode) {
            this.registrationCode = registrationCode;
        }

        @Override
        public GetRegistrationCodeResponse build() {
            return new GetRegistrationCodeResponse(this);
        }
    }
}
