/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetTopicRule operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetTopicRuleResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetTopicRuleResponse.Builder, GetTopicRuleResponse> {
    private final String ruleArn;

    private final TopicRule rule;

    private GetTopicRuleResponse(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The rule ARN.
     * </p>
     * 
     * @return The rule ARN.
     */
    public String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The rule.
     * </p>
     * 
     * @return The rule.
     */
    public TopicRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleArn() == null) ? 0 : ruleArn().hashCode());
        hashCode = 31 * hashCode + ((rule() == null) ? 0 : rule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicRuleResponse)) {
            return false;
        }
        GetTopicRuleResponse other = (GetTopicRuleResponse) obj;
        if (other.ruleArn() == null ^ this.ruleArn() == null) {
            return false;
        }
        if (other.ruleArn() != null && !other.ruleArn().equals(this.ruleArn())) {
            return false;
        }
        if (other.rule() == null ^ this.rule() == null) {
            return false;
        }
        if (other.rule() != null && !other.rule().equals(this.rule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleArn() != null) {
            sb.append("RuleArn: ").append(ruleArn()).append(",");
        }
        if (rule() != null) {
            sb.append("Rule: ").append(rule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleArn":
            return Optional.of(clazz.cast(ruleArn()));
        case "rule":
            return Optional.of(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GetTopicRuleResponse> {
        /**
         * <p>
         * The rule ARN.
         * </p>
         * 
         * @param ruleArn
         *        The rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The rule.
         * </p>
         * 
         * @param rule
         *        The rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(TopicRule rule);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private TopicRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicRuleResponse model) {
            ruleArn(model.ruleArn);
            rule(model.rule);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final TopicRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(TopicRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(TopicRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public GetTopicRuleResponse build() {
            return new GetTopicRuleResponse(this);
        }
    }
}
