/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the ListCertificatesByCA operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCertificatesByCARequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListCertificatesByCARequest.Builder, ListCertificatesByCARequest> {
    private final String caCertificateId;

    private final Integer pageSize;

    private final String marker;

    private final Boolean ascendingOrder;

    private ListCertificatesByCARequest(BuilderImpl builder) {
        this.caCertificateId = builder.caCertificateId;
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    /**
     * <p>
     * The ID of the CA certificate. This operation will list all registered device certificate that were signed by this
     * CA certificate.
     * </p>
     * 
     * @return The ID of the CA certificate. This operation will list all registered device certificate that were signed
     *         by this CA certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The result page size.
     * </p>
     * 
     * @return The result page size.
     */
    public Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies the order for results. If True, the results are returned in ascending order, based on the creation
     * date.
     * </p>
     * 
     * @return Specifies the order for results. If True, the results are returned in ascending order, based on the
     *         creation date.
     */
    public Boolean ascendingOrder() {
        return ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((caCertificateId() == null) ? 0 : caCertificateId().hashCode());
        hashCode = 31 * hashCode + ((pageSize() == null) ? 0 : pageSize().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((ascendingOrder() == null) ? 0 : ascendingOrder().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCARequest)) {
            return false;
        }
        ListCertificatesByCARequest other = (ListCertificatesByCARequest) obj;
        if (other.caCertificateId() == null ^ this.caCertificateId() == null) {
            return false;
        }
        if (other.caCertificateId() != null && !other.caCertificateId().equals(this.caCertificateId())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        if (other.pageSize() != null && !other.pageSize().equals(this.pageSize())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.ascendingOrder() == null ^ this.ascendingOrder() == null) {
            return false;
        }
        if (other.ascendingOrder() != null && !other.ascendingOrder().equals(this.ascendingOrder())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (caCertificateId() != null) {
            sb.append("CaCertificateId: ").append(caCertificateId()).append(",");
        }
        if (pageSize() != null) {
            sb.append("PageSize: ").append(pageSize()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (ascendingOrder() != null) {
            sb.append("AscendingOrder: ").append(ascendingOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caCertificateId":
            return Optional.of(clazz.cast(caCertificateId()));
        case "pageSize":
            return Optional.of(clazz.cast(pageSize()));
        case "marker":
            return Optional.of(clazz.cast(marker()));
        case "ascendingOrder":
            return Optional.of(clazz.cast(ascendingOrder()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCertificatesByCARequest> {
        /**
         * <p>
         * The ID of the CA certificate. This operation will list all registered device certificate that were signed by
         * this CA certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The ID of the CA certificate. This operation will list all registered device certificate that were
         *        signed by this CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The result page size.
         * </p>
         * 
         * @param pageSize
         *        The result page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies the order for results. If True, the results are returned in ascending order, based on the creation
         * date.
         * </p>
         * 
         * @param ascendingOrder
         *        Specifies the order for results. If True, the results are returned in ascending order, based on the
         *        creation date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);
    }

    static final class BuilderImpl implements Builder {
        private String caCertificateId;

        private Integer pageSize;

        private String marker;

        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCARequest model) {
            caCertificateId(model.caCertificateId);
            pageSize(model.pageSize);
            marker(model.marker);
            ascendingOrder(model.ascendingOrder);
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public ListCertificatesByCARequest build() {
            return new ListCertificatesByCARequest(this);
        }
    }
}
