/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListPolicyPrincipals operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPolicyPrincipalsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListPolicyPrincipalsResponse.Builder, ListPolicyPrincipalsResponse> {
    private final List<String> principals;

    private final String nextMarker;

    private ListPolicyPrincipalsResponse(BuilderImpl builder) {
        this.principals = builder.principals;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The descriptions of the principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The descriptions of the principals.
     */
    public List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * The marker for the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return The marker for the next set of results, or null if there are no additional results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((principals() == null) ? 0 : principals().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyPrincipalsResponse)) {
            return false;
        }
        ListPolicyPrincipalsResponse other = (ListPolicyPrincipalsResponse) obj;
        if (other.principals() == null ^ this.principals() == null) {
            return false;
        }
        if (other.principals() != null && !other.principals().equals(this.principals())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (principals() != null) {
            sb.append("Principals: ").append(principals()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principals":
            return Optional.of(clazz.cast(principals()));
        case "nextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListPolicyPrincipalsResponse> {
        /**
         * <p>
         * The descriptions of the principals.
         * </p>
         * 
         * @param principals
         *        The descriptions of the principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The descriptions of the principals.
         * </p>
         * 
         * @param principals
         *        The descriptions of the principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * The marker for the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results, or null if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl implements Builder {
        private List<String> principals;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyPrincipalsResponse model) {
            principals(model.principals);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListPolicyPrincipalsResponse build() {
            return new ListPolicyPrincipalsResponse(this);
        }
    }
}
