/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the ListPolicyVersions operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPolicyVersionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListPolicyVersionsRequest.Builder, ListPolicyVersionsRequest> {
    private final String policyName;

    private ListPolicyVersionsRequest(BuilderImpl builder) {
        this.policyName = builder.policyName;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsRequest)) {
            return false;
        }
        ListPolicyVersionsRequest other = (ListPolicyVersionsRequest) obj;
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListPolicyVersionsRequest> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsRequest model) {
            policyName(model.policyName);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public ListPolicyVersionsRequest build() {
            return new ListPolicyVersionsRequest(this);
        }
    }
}
