/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the ListTopicRules operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTopicRulesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTopicRulesRequest.Builder, ListTopicRulesRequest> {
    private final String topic;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean ruleDisabled;

    private ListTopicRulesRequest(BuilderImpl builder) {
        this.topic = builder.topic;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ruleDisabled = builder.ruleDisabled;
    }

    /**
     * <p>
     * The topic.
     * </p>
     * 
     * @return The topic.
     */
    public String topic() {
        return topic;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token used to retrieve the next value.
     * </p>
     * 
     * @return A token used to retrieve the next value.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public Boolean ruleDisabled() {
        return ruleDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topic() == null) ? 0 : topic().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((ruleDisabled() == null) ? 0 : ruleDisabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesRequest)) {
            return false;
        }
        ListTopicRulesRequest other = (ListTopicRulesRequest) obj;
        if (other.topic() == null ^ this.topic() == null) {
            return false;
        }
        if (other.topic() != null && !other.topic().equals(this.topic())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.ruleDisabled() == null ^ this.ruleDisabled() == null) {
            return false;
        }
        if (other.ruleDisabled() != null && !other.ruleDisabled().equals(this.ruleDisabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(ruleDisabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.of(clazz.cast(topic()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "ruleDisabled":
            return Optional.of(clazz.cast(ruleDisabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTopicRulesRequest> {
        /**
         * <p>
         * The topic.
         * </p>
         * 
         * @param topic
         *        The topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token used to retrieve the next value.
         * </p>
         * 
         * @param nextToken
         *        A token used to retrieve the next value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);
    }

    static final class BuilderImpl implements Builder {
        private String topic;

        private Integer maxResults;

        private String nextToken;

        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRulesRequest model) {
            topic(model.topic);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            ruleDisabled(model.ruleDisabled);
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        public ListTopicRulesRequest build() {
            return new ListTopicRulesRequest(this);
        }
    }
}
