/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the RegisterCACertificateResponse operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterCACertificateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RegisterCACertificateResponse.Builder, RegisterCACertificateResponse> {
    private final String certificateArn;

    private final String certificateId;

    private RegisterCACertificateResponse(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
    }

    /**
     * <p>
     * The CA certificate ARN.
     * </p>
     * 
     * @return The CA certificate ARN.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The CA certificate identifier.
     * </p>
     * 
     * @return The CA certificate identifier.
     */
    public String certificateId() {
        return certificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateArn() == null) ? 0 : certificateArn().hashCode());
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCACertificateResponse)) {
            return false;
        }
        RegisterCACertificateResponse other = (RegisterCACertificateResponse) obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificateArn() != null) {
            sb.append("CertificateArn: ").append(certificateArn()).append(",");
        }
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.of(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterCACertificateResponse> {
        /**
         * <p>
         * The CA certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        The CA certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The CA certificate identifier.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCACertificateResponse model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public RegisterCACertificateResponse build() {
            return new RegisterCACertificateResponse(this);
        }
    }
}
