/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the RejectCertificateTransfer operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RejectCertificateTransferRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RejectCertificateTransferRequest.Builder, RejectCertificateTransferRequest> {
    private final String certificateId;

    private final String rejectReason;

    private RejectCertificateTransferRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.rejectReason = builder.rejectReason;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The reason the certificate transfer was rejected.
     * </p>
     * 
     * @return The reason the certificate transfer was rejected.
     */
    public String rejectReason() {
        return rejectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((certificateId() == null) ? 0 : certificateId().hashCode());
        hashCode = 31 * hashCode + ((rejectReason() == null) ? 0 : rejectReason().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectCertificateTransferRequest)) {
            return false;
        }
        RejectCertificateTransferRequest other = (RejectCertificateTransferRequest) obj;
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.rejectReason() == null ^ this.rejectReason() == null) {
            return false;
        }
        if (other.rejectReason() != null && !other.rejectReason().equals(this.rejectReason())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (rejectReason() != null) {
            sb.append("RejectReason: ").append(rejectReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        case "rejectReason":
            return Optional.of(clazz.cast(rejectReason()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RejectCertificateTransferRequest> {
        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The reason the certificate transfer was rejected.
         * </p>
         * 
         * @param rejectReason
         *        The reason the certificate transfer was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectReason(String rejectReason);
    }

    static final class BuilderImpl implements Builder {
        private String certificateId;

        private String rejectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectCertificateTransferRequest model) {
            certificateId(model.certificateId);
            rejectReason(model.rejectReason);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getRejectReason() {
            return rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        @Override
        public RejectCertificateTransferRequest build() {
            return new RejectCertificateTransferRequest(this);
        }
    }
}
