/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.TopicRuleListItemMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TopicRuleListItem implements StructuredPojo, ToCopyableBuilder<TopicRuleListItem.Builder, TopicRuleListItem> {
    private final String ruleArn;

    private final String ruleName;

    private final String topicPattern;

    private final Instant createdAt;

    private final Boolean ruleDisabled;

    private TopicRuleListItem(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleName = builder.ruleName;
        this.topicPattern = builder.topicPattern;
        this.createdAt = builder.createdAt;
        this.ruleDisabled = builder.ruleDisabled;
    }

    /**
     * <p>
     * The rule ARN.
     * </p>
     * 
     * @return The rule ARN.
     */
    public String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The pattern for the topic names that apply.
     * </p>
     * 
     * @return The pattern for the topic names that apply.
     */
    public String topicPattern() {
        return topicPattern;
    }

    /**
     * <p>
     * The date and time the rule was created.
     * </p>
     * 
     * @return The date and time the rule was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies whether the rule is disabled.
     * </p>
     * 
     * @return Specifies whether the rule is disabled.
     */
    public Boolean ruleDisabled() {
        return ruleDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleArn() == null) ? 0 : ruleArn().hashCode());
        hashCode = 31 * hashCode + ((ruleName() == null) ? 0 : ruleName().hashCode());
        hashCode = 31 * hashCode + ((topicPattern() == null) ? 0 : topicPattern().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((ruleDisabled() == null) ? 0 : ruleDisabled().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleListItem)) {
            return false;
        }
        TopicRuleListItem other = (TopicRuleListItem) obj;
        if (other.ruleArn() == null ^ this.ruleArn() == null) {
            return false;
        }
        if (other.ruleArn() != null && !other.ruleArn().equals(this.ruleArn())) {
            return false;
        }
        if (other.ruleName() == null ^ this.ruleName() == null) {
            return false;
        }
        if (other.ruleName() != null && !other.ruleName().equals(this.ruleName())) {
            return false;
        }
        if (other.topicPattern() == null ^ this.topicPattern() == null) {
            return false;
        }
        if (other.topicPattern() != null && !other.topicPattern().equals(this.topicPattern())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.ruleDisabled() == null ^ this.ruleDisabled() == null) {
            return false;
        }
        if (other.ruleDisabled() != null && !other.ruleDisabled().equals(this.ruleDisabled())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ruleArn() != null) {
            sb.append("RuleArn: ").append(ruleArn()).append(",");
        }
        if (ruleName() != null) {
            sb.append("RuleName: ").append(ruleName()).append(",");
        }
        if (topicPattern() != null) {
            sb.append("TopicPattern: ").append(topicPattern()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(ruleDisabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleArn":
            return Optional.of(clazz.cast(ruleArn()));
        case "ruleName":
            return Optional.of(clazz.cast(ruleName()));
        case "topicPattern":
            return Optional.of(clazz.cast(topicPattern()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "ruleDisabled":
            return Optional.of(clazz.cast(ruleDisabled()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRuleListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TopicRuleListItem> {
        /**
         * <p>
         * The rule ARN.
         * </p>
         * 
         * @param ruleArn
         *        The rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The pattern for the topic names that apply.
         * </p>
         * 
         * @param topicPattern
         *        The pattern for the topic names that apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPattern(String topicPattern);

        /**
         * <p>
         * The date and time the rule was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies whether the rule is disabled.
         * </p>
         * 
         * @param ruleDisabled
         *        Specifies whether the rule is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDisabled(Boolean ruleDisabled);
    }

    static final class BuilderImpl implements Builder {
        private String ruleArn;

        private String ruleName;

        private String topicPattern;

        private Instant createdAt;

        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleListItem model) {
            ruleArn(model.ruleArn);
            ruleName(model.ruleName);
            topicPattern(model.topicPattern);
            createdAt(model.createdAt);
            ruleDisabled(model.ruleDisabled);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getTopicPattern() {
            return topicPattern;
        }

        @Override
        public final Builder topicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
            return this;
        }

        public final void setTopicPattern(String topicPattern) {
            this.topicPattern = topicPattern;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getRuleDisabled() {
            return ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        public TopicRuleListItem build() {
            return new TopicRuleListItem(this);
        }
    }
}
