/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the UpdateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateThingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateThingRequest.Builder, UpdateThingRequest> {
    private final String thingName;

    private final String thingTypeName;

    private final AttributePayload attributePayload;

    private final Long expectedVersion;

    private final Boolean removeThingType;

    private UpdateThingRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.expectedVersion = builder.expectedVersion;
        this.removeThingType = builder.removeThingType;
    }

    /**
     * <p>
     * The name of the thing to update.
     * </p>
     * 
     * @return The name of the thing to update.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * A list of thing attributes, a JSON string containing name-value pairs. For example:
     * </p>
     * <p>
     * <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
     * </p>
     * <p>
     * This data is used to add new attributes or update existing attributes.
     * </p>
     * 
     * @return A list of thing attributes, a JSON string containing name-value pairs. For example:</p>
     *         <p>
     *         <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
     *         </p>
     *         <p>
     *         This data is used to add new attributes or update existing attributes.
     */
    public AttributePayload attributePayload() {
        return attributePayload;
    }

    /**
     * <p>
     * The expected version of the thing record in the registry. If the version of the record in the registry does not
     * match the expected version specified in the request, the <code>UpdateThing</code> request is rejected with a
     * <code>VersionConflictException</code>.
     * </p>
     * 
     * @return The expected version of the thing record in the registry. If the version of the record in the registry
     *         does not match the expected version specified in the request, the <code>UpdateThing</code> request is
     *         rejected with a <code>VersionConflictException</code>.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * <p>
     * Remove a thing type association. If <b>true</b>, the assocation is removed.
     * </p>
     * 
     * @return Remove a thing type association. If <b>true</b>, the assocation is removed.
     */
    public Boolean removeThingType() {
        return removeThingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((thingName() == null) ? 0 : thingName().hashCode());
        hashCode = 31 * hashCode + ((thingTypeName() == null) ? 0 : thingTypeName().hashCode());
        hashCode = 31 * hashCode + ((attributePayload() == null) ? 0 : attributePayload().hashCode());
        hashCode = 31 * hashCode + ((expectedVersion() == null) ? 0 : expectedVersion().hashCode());
        hashCode = 31 * hashCode + ((removeThingType() == null) ? 0 : removeThingType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRequest)) {
            return false;
        }
        UpdateThingRequest other = (UpdateThingRequest) obj;
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.attributePayload() == null ^ this.attributePayload() == null) {
            return false;
        }
        if (other.attributePayload() != null && !other.attributePayload().equals(this.attributePayload())) {
            return false;
        }
        if (other.expectedVersion() == null ^ this.expectedVersion() == null) {
            return false;
        }
        if (other.expectedVersion() != null && !other.expectedVersion().equals(this.expectedVersion())) {
            return false;
        }
        if (other.removeThingType() == null ^ this.removeThingType() == null) {
            return false;
        }
        if (other.removeThingType() != null && !other.removeThingType().equals(this.removeThingType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (attributePayload() != null) {
            sb.append("AttributePayload: ").append(attributePayload()).append(",");
        }
        if (expectedVersion() != null) {
            sb.append("ExpectedVersion: ").append(expectedVersion()).append(",");
        }
        if (removeThingType() != null) {
            sb.append("RemoveThingType: ").append(removeThingType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.of(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "attributePayload":
            return Optional.of(clazz.cast(attributePayload()));
        case "expectedVersion":
            return Optional.of(clazz.cast(expectedVersion()));
        case "removeThingType":
            return Optional.of(clazz.cast(removeThingType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateThingRequest> {
        /**
         * <p>
         * The name of the thing to update.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * A list of thing attributes, a JSON string containing name-value pairs. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
         * </p>
         * <p>
         * This data is used to add new attributes or update existing attributes.
         * </p>
         * 
         * @param attributePayload
         *        A list of thing attributes, a JSON string containing name-value pairs. For example:</p>
         *        <p>
         *        <code>{\"attributes\":{\"name1\":\"value2\"}}</code>
         *        </p>
         *        <p>
         *        This data is used to add new attributes or update existing attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePayload(AttributePayload attributePayload);

        /**
         * <p>
         * The expected version of the thing record in the registry. If the version of the record in the registry does
         * not match the expected version specified in the request, the <code>UpdateThing</code> request is rejected
         * with a <code>VersionConflictException</code>.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the thing record in the registry. If the version of the record in the registry
         *        does not match the expected version specified in the request, the <code>UpdateThing</code> request is
         *        rejected with a <code>VersionConflictException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * Remove a thing type association. If <b>true</b>, the assocation is removed.
         * </p>
         * 
         * @param removeThingType
         *        Remove a thing type association. If <b>true</b>, the assocation is removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeThingType(Boolean removeThingType);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private AttributePayload attributePayload;

        private Long expectedVersion;

        private Boolean removeThingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRequest model) {
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            attributePayload(model.attributePayload);
            expectedVersion(model.expectedVersion);
            removeThingType(model.removeThingType);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return attributePayload != null ? attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Boolean getRemoveThingType() {
            return removeThingType;
        }

        @Override
        public final Builder removeThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
            return this;
        }

        public final void setRemoveThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
        }

        @Override
        public UpdateThingRequest build() {
            return new UpdateThingRequest(this);
        }
    }
}
