/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.iot.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Action JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ActionUnmarshaller implements Unmarshaller<Action, JsonUnmarshallerContext> {

    public Action unmarshall(JsonUnmarshallerContext context) throws Exception {
        Action.Builder actionBuilder = Action.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("dynamoDB", targetDepth)) {
                    context.nextToken();
                    actionBuilder.dynamoDB(DynamoDBActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("dynamoDBv2", targetDepth)) {
                    context.nextToken();
                    actionBuilder.dynamoDBv2(DynamoDBv2ActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("lambda", targetDepth)) {
                    context.nextToken();
                    actionBuilder.lambda(LambdaActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sns", targetDepth)) {
                    context.nextToken();
                    actionBuilder.sns(SnsActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sqs", targetDepth)) {
                    context.nextToken();
                    actionBuilder.sqs(SqsActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("kinesis", targetDepth)) {
                    context.nextToken();
                    actionBuilder.kinesis(KinesisActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("republish", targetDepth)) {
                    context.nextToken();
                    actionBuilder.republish(RepublishActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("s3", targetDepth)) {
                    context.nextToken();
                    actionBuilder.s3(S3ActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("firehose", targetDepth)) {
                    context.nextToken();
                    actionBuilder.firehose(FirehoseActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cloudwatchMetric", targetDepth)) {
                    context.nextToken();
                    actionBuilder.cloudwatchMetric(CloudwatchMetricActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("cloudwatchAlarm", targetDepth)) {
                    context.nextToken();
                    actionBuilder.cloudwatchAlarm(CloudwatchAlarmActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("elasticsearch", targetDepth)) {
                    context.nextToken();
                    actionBuilder.elasticsearch(ElasticsearchActionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("salesforce", targetDepth)) {
                    context.nextToken();
                    actionBuilder.salesforce(SalesforceActionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return actionBuilder.build();
    }

    private static final ActionUnmarshaller INSTANCE = new ActionUnmarshaller();

    public static ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
