/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.services.iot.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * CertificateDescriptionMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class CertificateDescriptionMarshaller {

    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").build();
    private static final MarshallingInfo<String> CACERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caCertificateId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").build();
    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").build();
    private static final MarshallingInfo<String> PREVIOUSOWNEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousOwnedBy").build();
    private static final MarshallingInfo<java.time.Instant> CREATIONDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate")
            .build();
    private static final MarshallingInfo<java.time.Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate")
            .build();
    private static final MarshallingInfo<StructuredPojo> TRANSFERDATA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferData")
            .build();

    private static final CertificateDescriptionMarshaller INSTANCE = new CertificateDescriptionMarshaller();

    public static CertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(CertificateDescription certificateDescription, ProtocolMarshaller protocolMarshaller) {

        if (certificateDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(certificateDescription.certificateArn(), CERTIFICATEARN_BINDING);

            protocolMarshaller.marshall(certificateDescription.certificateId(), CERTIFICATEID_BINDING);

            protocolMarshaller.marshall(certificateDescription.caCertificateId(), CACERTIFICATEID_BINDING);

            protocolMarshaller.marshall(certificateDescription.statusString(), STATUS_BINDING);

            protocolMarshaller.marshall(certificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);

            protocolMarshaller.marshall(certificateDescription.ownedBy(), OWNEDBY_BINDING);

            protocolMarshaller.marshall(certificateDescription.previousOwnedBy(), PREVIOUSOWNEDBY_BINDING);

            protocolMarshaller.marshall(certificateDescription.creationDate(), CREATIONDATE_BINDING);

            protocolMarshaller.marshall(certificateDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);

            protocolMarshaller.marshall(certificateDescription.transferData(), TRANSFERDATA_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
