/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CloudwatchAlarmAction;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;
import software.amazon.awssdk.services.iot.model.DynamoDBv2Action;
import software.amazon.awssdk.services.iot.model.ElasticsearchAction;
import software.amazon.awssdk.services.iot.model.FirehoseAction;
import software.amazon.awssdk.services.iot.model.KinesisAction;
import software.amazon.awssdk.services.iot.model.LambdaAction;
import software.amazon.awssdk.services.iot.model.RepublishAction;
import software.amazon.awssdk.services.iot.model.S3Action;
import software.amazon.awssdk.services.iot.model.SalesforceAction;
import software.amazon.awssdk.services.iot.model.SnsAction;
import software.amazon.awssdk.services.iot.model.SqsAction;
import software.amazon.awssdk.services.iot.transform.ActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Action
implements StructuredPojo,
ToCopyableBuilder<Builder, Action> {
    private final DynamoDBAction dynamoDB;
    private final DynamoDBv2Action dynamoDBv2;
    private final LambdaAction lambda;
    private final SnsAction sns;
    private final SqsAction sqs;
    private final KinesisAction kinesis;
    private final RepublishAction republish;
    private final S3Action s3;
    private final FirehoseAction firehose;
    private final CloudwatchMetricAction cloudwatchMetric;
    private final CloudwatchAlarmAction cloudwatchAlarm;
    private final ElasticsearchAction elasticsearch;
    private final SalesforceAction salesforce;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
    }

    public DynamoDBAction dynamoDB() {
        return this.dynamoDB;
    }

    public DynamoDBv2Action dynamoDBv2() {
        return this.dynamoDBv2;
    }

    public LambdaAction lambda() {
        return this.lambda;
    }

    public SnsAction sns() {
        return this.sns;
    }

    public SqsAction sqs() {
        return this.sqs;
    }

    public KinesisAction kinesis() {
        return this.kinesis;
    }

    public RepublishAction republish() {
        return this.republish;
    }

    public S3Action s3() {
        return this.s3;
    }

    public FirehoseAction firehose() {
        return this.firehose;
    }

    public CloudwatchMetricAction cloudwatchMetric() {
        return this.cloudwatchMetric;
    }

    public CloudwatchAlarmAction cloudwatchAlarm() {
        return this.cloudwatchAlarm;
    }

    public ElasticsearchAction elasticsearch() {
        return this.elasticsearch;
    }

    public SalesforceAction salesforce() {
        return this.salesforce;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dynamoDB() == null ? 0 : this.dynamoDB().hashCode());
        hashCode = 31 * hashCode + (this.dynamoDBv2() == null ? 0 : this.dynamoDBv2().hashCode());
        hashCode = 31 * hashCode + (this.lambda() == null ? 0 : this.lambda().hashCode());
        hashCode = 31 * hashCode + (this.sns() == null ? 0 : this.sns().hashCode());
        hashCode = 31 * hashCode + (this.sqs() == null ? 0 : this.sqs().hashCode());
        hashCode = 31 * hashCode + (this.kinesis() == null ? 0 : this.kinesis().hashCode());
        hashCode = 31 * hashCode + (this.republish() == null ? 0 : this.republish().hashCode());
        hashCode = 31 * hashCode + (this.s3() == null ? 0 : this.s3().hashCode());
        hashCode = 31 * hashCode + (this.firehose() == null ? 0 : this.firehose().hashCode());
        hashCode = 31 * hashCode + (this.cloudwatchMetric() == null ? 0 : this.cloudwatchMetric().hashCode());
        hashCode = 31 * hashCode + (this.cloudwatchAlarm() == null ? 0 : this.cloudwatchAlarm().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearch() == null ? 0 : this.elasticsearch().hashCode());
        hashCode = 31 * hashCode + (this.salesforce() == null ? 0 : this.salesforce().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        if (other.dynamoDB() == null ^ this.dynamoDB() == null) {
            return false;
        }
        if (other.dynamoDB() != null && !other.dynamoDB().equals(this.dynamoDB())) {
            return false;
        }
        if (other.dynamoDBv2() == null ^ this.dynamoDBv2() == null) {
            return false;
        }
        if (other.dynamoDBv2() != null && !other.dynamoDBv2().equals(this.dynamoDBv2())) {
            return false;
        }
        if (other.lambda() == null ^ this.lambda() == null) {
            return false;
        }
        if (other.lambda() != null && !other.lambda().equals(this.lambda())) {
            return false;
        }
        if (other.sns() == null ^ this.sns() == null) {
            return false;
        }
        if (other.sns() != null && !other.sns().equals(this.sns())) {
            return false;
        }
        if (other.sqs() == null ^ this.sqs() == null) {
            return false;
        }
        if (other.sqs() != null && !other.sqs().equals(this.sqs())) {
            return false;
        }
        if (other.kinesis() == null ^ this.kinesis() == null) {
            return false;
        }
        if (other.kinesis() != null && !other.kinesis().equals(this.kinesis())) {
            return false;
        }
        if (other.republish() == null ^ this.republish() == null) {
            return false;
        }
        if (other.republish() != null && !other.republish().equals(this.republish())) {
            return false;
        }
        if (other.s3() == null ^ this.s3() == null) {
            return false;
        }
        if (other.s3() != null && !other.s3().equals(this.s3())) {
            return false;
        }
        if (other.firehose() == null ^ this.firehose() == null) {
            return false;
        }
        if (other.firehose() != null && !other.firehose().equals(this.firehose())) {
            return false;
        }
        if (other.cloudwatchMetric() == null ^ this.cloudwatchMetric() == null) {
            return false;
        }
        if (other.cloudwatchMetric() != null && !other.cloudwatchMetric().equals(this.cloudwatchMetric())) {
            return false;
        }
        if (other.cloudwatchAlarm() == null ^ this.cloudwatchAlarm() == null) {
            return false;
        }
        if (other.cloudwatchAlarm() != null && !other.cloudwatchAlarm().equals(this.cloudwatchAlarm())) {
            return false;
        }
        if (other.elasticsearch() == null ^ this.elasticsearch() == null) {
            return false;
        }
        if (other.elasticsearch() != null && !other.elasticsearch().equals(this.elasticsearch())) {
            return false;
        }
        if (other.salesforce() == null ^ this.salesforce() == null) {
            return false;
        }
        return other.salesforce() == null || other.salesforce().equals(this.salesforce());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dynamoDB() != null) {
            sb.append("DynamoDB: ").append(this.dynamoDB()).append(",");
        }
        if (this.dynamoDBv2() != null) {
            sb.append("DynamoDBv2: ").append(this.dynamoDBv2()).append(",");
        }
        if (this.lambda() != null) {
            sb.append("Lambda: ").append(this.lambda()).append(",");
        }
        if (this.sns() != null) {
            sb.append("Sns: ").append(this.sns()).append(",");
        }
        if (this.sqs() != null) {
            sb.append("Sqs: ").append(this.sqs()).append(",");
        }
        if (this.kinesis() != null) {
            sb.append("Kinesis: ").append(this.kinesis()).append(",");
        }
        if (this.republish() != null) {
            sb.append("Republish: ").append(this.republish()).append(",");
        }
        if (this.s3() != null) {
            sb.append("S3: ").append(this.s3()).append(",");
        }
        if (this.firehose() != null) {
            sb.append("Firehose: ").append(this.firehose()).append(",");
        }
        if (this.cloudwatchMetric() != null) {
            sb.append("CloudwatchMetric: ").append(this.cloudwatchMetric()).append(",");
        }
        if (this.cloudwatchAlarm() != null) {
            sb.append("CloudwatchAlarm: ").append(this.cloudwatchAlarm()).append(",");
        }
        if (this.elasticsearch() != null) {
            sb.append("Elasticsearch: ").append(this.elasticsearch()).append(",");
        }
        if (this.salesforce() != null) {
            sb.append("Salesforce: ").append(this.salesforce()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dynamoDB": {
                return Optional.of(clazz.cast(this.dynamoDB()));
            }
            case "dynamoDBv2": {
                return Optional.of(clazz.cast(this.dynamoDBv2()));
            }
            case "lambda": {
                return Optional.of(clazz.cast(this.lambda()));
            }
            case "sns": {
                return Optional.of(clazz.cast(this.sns()));
            }
            case "sqs": {
                return Optional.of(clazz.cast(this.sqs()));
            }
            case "kinesis": {
                return Optional.of(clazz.cast(this.kinesis()));
            }
            case "republish": {
                return Optional.of(clazz.cast(this.republish()));
            }
            case "s3": {
                return Optional.of(clazz.cast(this.s3()));
            }
            case "firehose": {
                return Optional.of(clazz.cast(this.firehose()));
            }
            case "cloudwatchMetric": {
                return Optional.of(clazz.cast(this.cloudwatchMetric()));
            }
            case "cloudwatchAlarm": {
                return Optional.of(clazz.cast(this.cloudwatchAlarm()));
            }
            case "elasticsearch": {
                return Optional.of(clazz.cast(this.elasticsearch()));
            }
            case "salesforce": {
                return Optional.of(clazz.cast(this.salesforce()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private DynamoDBAction dynamoDB;
        private DynamoDBv2Action dynamoDBv2;
        private LambdaAction lambda;
        private SnsAction sns;
        private SqsAction sqs;
        private KinesisAction kinesis;
        private RepublishAction republish;
        private S3Action s3;
        private FirehoseAction firehose;
        private CloudwatchMetricAction cloudwatchMetric;
        private CloudwatchAlarmAction cloudwatchAlarm;
        private ElasticsearchAction elasticsearch;
        private SalesforceAction salesforce;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.dynamoDB(model.dynamoDB);
            this.dynamoDBv2(model.dynamoDBv2);
            this.lambda(model.lambda);
            this.sns(model.sns);
            this.sqs(model.sqs);
            this.kinesis(model.kinesis);
            this.republish(model.republish);
            this.s3(model.s3);
            this.firehose(model.firehose);
            this.cloudwatchMetric(model.cloudwatchMetric);
            this.cloudwatchAlarm(model.cloudwatchAlarm);
            this.elasticsearch(model.elasticsearch);
            this.salesforce(model.salesforce);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return this.dynamoDB != null ? this.dynamoDB.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return this.dynamoDBv2 != null ? this.dynamoDBv2.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        public final LambdaAction.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public final SnsAction.Builder getSns() {
            return this.sns != null ? this.sns.toBuilder() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        public final SqsAction.Builder getSqs() {
            return this.sqs != null ? this.sqs.toBuilder() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        public final KinesisAction.Builder getKinesis() {
            return this.kinesis != null ? this.kinesis.toBuilder() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        public final RepublishAction.Builder getRepublish() {
            return this.republish != null ? this.republish.toBuilder() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        public final S3Action.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final FirehoseAction.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return this.cloudwatchMetric != null ? this.cloudwatchMetric.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return this.cloudwatchAlarm != null ? this.cloudwatchAlarm.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return this.elasticsearch != null ? this.elasticsearch.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Action> {
        public Builder dynamoDB(DynamoDBAction var1);

        public Builder dynamoDBv2(DynamoDBv2Action var1);

        public Builder lambda(LambdaAction var1);

        public Builder sns(SnsAction var1);

        public Builder sqs(SqsAction var1);

        public Builder kinesis(KinesisAction var1);

        public Builder republish(RepublishAction var1);

        public Builder s3(S3Action var1);

        public Builder firehose(FirehoseAction var1);

        public Builder cloudwatchMetric(CloudwatchMetricAction var1);

        public Builder cloudwatchAlarm(CloudwatchAlarmAction var1);

        public Builder elasticsearch(ElasticsearchAction var1);

        public Builder salesforce(SalesforceAction var1);
    }
}

