/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.transform.CACertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CACertificateDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, CACertificateDescription> {
    private final String certificateArn;
    private final String certificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final Instant creationDate;
    private final String autoRegistrationStatus;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus status() {
        return CACertificateStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String ownedBy() {
        return this.ownedBy;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.autoRegistrationStatus);
    }

    public String autoRegistrationStatusString() {
        return this.autoRegistrationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateArn() == null ? 0 : this.certificateArn().hashCode());
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.certificatePem() == null ? 0 : this.certificatePem().hashCode());
        hashCode = 31 * hashCode + (this.ownedBy() == null ? 0 : this.ownedBy().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.autoRegistrationStatusString() == null ? 0 : this.autoRegistrationStatusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription)obj;
        if (other.certificateArn() == null ^ this.certificateArn() == null) {
            return false;
        }
        if (other.certificateArn() != null && !other.certificateArn().equals(this.certificateArn())) {
            return false;
        }
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.certificatePem() == null ^ this.certificatePem() == null) {
            return false;
        }
        if (other.certificatePem() != null && !other.certificatePem().equals(this.certificatePem())) {
            return false;
        }
        if (other.ownedBy() == null ^ this.ownedBy() == null) {
            return false;
        }
        if (other.ownedBy() != null && !other.ownedBy().equals(this.ownedBy())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.autoRegistrationStatusString() == null ^ this.autoRegistrationStatusString() == null) {
            return false;
        }
        return other.autoRegistrationStatusString() == null || other.autoRegistrationStatusString().equals(this.autoRegistrationStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateArn() != null) {
            sb.append("CertificateArn: ").append(this.certificateArn()).append(",");
        }
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.certificatePem() != null) {
            sb.append("CertificatePem: ").append(this.certificatePem()).append(",");
        }
        if (this.ownedBy() != null) {
            sb.append("OwnedBy: ").append(this.ownedBy()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.autoRegistrationStatusString() != null) {
            sb.append("AutoRegistrationStatus: ").append(this.autoRegistrationStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "certificatePem": {
                return Optional.of(clazz.cast(this.certificatePem()));
            }
            case "ownedBy": {
                return Optional.of(clazz.cast(this.ownedBy()));
            }
            case "creationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "autoRegistrationStatus": {
                return Optional.of(clazz.cast(this.autoRegistrationStatusString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CACertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private Instant creationDate;
        private String autoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.status(model.status);
            this.certificatePem(model.certificatePem);
            this.ownedBy(model.ownedBy);
            this.creationDate(model.creationDate);
            this.autoRegistrationStatus(model.autoRegistrationStatus);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getAutoRegistrationStatus() {
            return this.autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus.toString());
            return this;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CACertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder status(String var1);

        public Builder status(CACertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder autoRegistrationStatus(String var1);

        public Builder autoRegistrationStatus(AutoRegistrationStatus var1);
    }
}

