/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePolicyVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreatePolicyVersionRequest> {
    private final String policyName;
    private final String policyDocument;
    private final Boolean setAsDefault;

    private CreatePolicyVersionRequest(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.setAsDefault = builder.setAsDefault;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public Boolean setAsDefault() {
        return this.setAsDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        hashCode = 31 * hashCode + (this.setAsDefault() == null ? 0 : this.setAsDefault().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionRequest)) {
            return false;
        }
        CreatePolicyVersionRequest other = (CreatePolicyVersionRequest)((Object)obj);
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.setAsDefault() == null ^ this.setAsDefault() == null) {
            return false;
        }
        return other.setAsDefault() == null || other.setAsDefault().equals(this.setAsDefault());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.setAsDefault() != null) {
            sb.append("SetAsDefault: ").append(this.setAsDefault()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "policyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "setAsDefault": {
                return Optional.of(clazz.cast(this.setAsDefault()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyDocument;
        private Boolean setAsDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionRequest model) {
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
            this.setAsDefault(model.setAsDefault);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Boolean getSetAsDefault() {
            return this.setAsDefault;
        }

        @Override
        public final Builder setAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
            return this;
        }

        public final void setSetAsDefault(Boolean setAsDefault) {
            this.setAsDefault = setAsDefault;
        }

        public CreatePolicyVersionRequest build() {
            return new CreatePolicyVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreatePolicyVersionRequest> {
        public Builder policyName(String var1);

        public Builder policyDocument(String var1);

        public Builder setAsDefault(Boolean var1);
    }
}

