/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeThingResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeThingResponse> {
    private final String defaultClientId;
    private final String thingName;
    private final String thingTypeName;
    private final Map<String, String> attributes;
    private final Long version;

    private DescribeThingResponse(BuilderImpl builder) {
        this.defaultClientId = builder.defaultClientId;
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    public String defaultClientId() {
        return this.defaultClientId;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Long version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.defaultClientId() == null ? 0 : this.defaultClientId().hashCode());
        hashCode = 31 * hashCode + (this.thingName() == null ? 0 : this.thingName().hashCode());
        hashCode = 31 * hashCode + (this.thingTypeName() == null ? 0 : this.thingTypeName().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingResponse)) {
            return false;
        }
        DescribeThingResponse other = (DescribeThingResponse)((Object)obj);
        if (other.defaultClientId() == null ^ this.defaultClientId() == null) {
            return false;
        }
        if (other.defaultClientId() != null && !other.defaultClientId().equals(this.defaultClientId())) {
            return false;
        }
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        if (other.thingName() != null && !other.thingName().equals(this.thingName())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        if (other.thingTypeName() != null && !other.thingTypeName().equals(this.thingTypeName())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.defaultClientId() != null) {
            sb.append("DefaultClientId: ").append(this.defaultClientId()).append(",");
        }
        if (this.thingName() != null) {
            sb.append("ThingName: ").append(this.thingName()).append(",");
        }
        if (this.thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(this.thingTypeName()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultClientId": {
                return Optional.of(clazz.cast(this.defaultClientId()));
            }
            case "thingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
            case "attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultClientId;
        private String thingName;
        private String thingTypeName;
        private Map<String, String> attributes;
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingResponse model) {
            this.defaultClientId(model.defaultClientId);
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributes(model.attributes);
            this.version(model.version);
        }

        public final String getDefaultClientId() {
            return this.defaultClientId;
        }

        @Override
        public final Builder defaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        public final void setDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public DescribeThingResponse build() {
            return new DescribeThingResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeThingResponse> {
        public Builder defaultClientId(String var1);

        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder version(Long var1);
    }
}

