/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLoggingOptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetLoggingOptionsResponse> {
    private final String roleArn;
    private final String logLevel;

    private GetLoggingOptionsResponse(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.logLevel = builder.logLevel;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.logLevelString() == null ? 0 : this.logLevelString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoggingOptionsResponse)) {
            return false;
        }
        GetLoggingOptionsResponse other = (GetLoggingOptionsResponse)((Object)obj);
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.logLevelString() == null ^ this.logLevelString() == null) {
            return false;
        }
        return other.logLevelString() == null || other.logLevelString().equals(this.logLevelString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.logLevelString() != null) {
            sb.append("LogLevel: ").append(this.logLevelString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "logLevel": {
                return Optional.of(clazz.cast(this.logLevelString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoggingOptionsResponse model) {
            this.roleArn(model.roleArn);
            this.logLevel(model.logLevel);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public GetLoggingOptionsResponse build() {
            return new GetLoggingOptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetLoggingOptionsResponse> {
        public Builder roleArn(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

