/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.Certificate;
import software.amazon.awssdk.services.iot.model.CertificatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesByCAResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCertificatesByCAResponse> {
    private final List<Certificate> certificates;
    private final String nextMarker;

    private ListCertificatesByCAResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<Certificate> certificates() {
        return this.certificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificates() == null ? 0 : this.certificates().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCAResponse)) {
            return false;
        }
        ListCertificatesByCAResponse other = (ListCertificatesByCAResponse)((Object)obj);
        if (other.certificates() == null ^ this.certificates() == null) {
            return false;
        }
        if (other.certificates() != null && !other.certificates().equals(this.certificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificates() != null) {
            sb.append("Certificates: ").append(this.certificates()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificates": {
                return Optional.of(clazz.cast(this.certificates()));
            }
            case "nextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Certificate> certificates;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCAResponse model) {
            this.certificates(model.certificates);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return this.certificates != null ? (Collection)this.certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public ListCertificatesByCAResponse build() {
            return new ListCertificatesByCAResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCertificatesByCAResponse> {
        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder nextMarker(String var1);
    }
}

