/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;
import software.amazon.awssdk.services.iot.model.OutgoingCertificatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOutgoingCertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
    private final List<OutgoingCertificate> outgoingCertificates;
    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    public List<OutgoingCertificate> outgoingCertificates() {
        return this.outgoingCertificates;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outgoingCertificates() == null ? 0 : this.outgoingCertificates().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse)((Object)obj);
        if (other.outgoingCertificates() == null ^ this.outgoingCertificates() == null) {
            return false;
        }
        if (other.outgoingCertificates() != null && !other.outgoingCertificates().equals(this.outgoingCertificates())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outgoingCertificates() != null) {
            sb.append("OutgoingCertificates: ").append(this.outgoingCertificates()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outgoingCertificates": {
                return Optional.of(clazz.cast(this.outgoingCertificates()));
            }
            case "nextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<OutgoingCertificate> outgoingCertificates;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            this.outgoingCertificates(model.outgoingCertificates);
            this.nextMarker(model.nextMarker);
        }

        public final Collection<OutgoingCertificate.Builder> getOutgoingCertificates() {
            return this.outgoingCertificates != null ? (Collection)this.outgoingCertificates.stream().map(OutgoingCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate ... outgoingCertificates) {
            this.outgoingCertificates(Arrays.asList(outgoingCertificates));
            return this;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate.BuilderImpl> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copyFromBuilder(outgoingCertificates);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        public Builder outgoingCertificates(Collection<OutgoingCertificate> var1);

        public Builder outgoingCertificates(OutgoingCertificate ... var1);

        public Builder nextMarker(String var1);
    }
}

