/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPrincipalThingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListPrincipalThingsRequest> {
    private final String nextToken;
    private final Integer maxResults;
    private final String principal;

    private ListPrincipalThingsRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.principal = builder.principal;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String principal() {
        return this.principal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.principal() == null ? 0 : this.principal().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalThingsRequest)) {
            return false;
        }
        ListPrincipalThingsRequest other = (ListPrincipalThingsRequest)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.principal() == null ^ this.principal() == null) {
            return false;
        }
        return other.principal() == null || other.principal().equals(this.principal());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.principal() != null) {
            sb.append("Principal: ").append(this.principal()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "principal": {
                return Optional.of(clazz.cast(this.principal()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalThingsRequest model) {
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.principal(model.principal);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public ListPrincipalThingsRequest build() {
            return new ListPrincipalThingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPrincipalThingsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder principal(String var1);
    }
}

