/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.ThingTypeDefinition;
import software.amazon.awssdk.services.iot.model.ThingTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListThingTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListThingTypesResponse> {
    private final List<ThingTypeDefinition> thingTypes;
    private final String nextToken;

    private ListThingTypesResponse(BuilderImpl builder) {
        this.thingTypes = builder.thingTypes;
        this.nextToken = builder.nextToken;
    }

    public List<ThingTypeDefinition> thingTypes() {
        return this.thingTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.thingTypes() == null ? 0 : this.thingTypes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingTypesResponse)) {
            return false;
        }
        ListThingTypesResponse other = (ListThingTypesResponse)((Object)obj);
        if (other.thingTypes() == null ^ this.thingTypes() == null) {
            return false;
        }
        if (other.thingTypes() != null && !other.thingTypes().equals(this.thingTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.thingTypes() != null) {
            sb.append("ThingTypes: ").append(this.thingTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypes": {
                return Optional.of(clazz.cast(this.thingTypes()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ThingTypeDefinition> thingTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingTypesResponse model) {
            this.thingTypes(model.thingTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<ThingTypeDefinition.Builder> getThingTypes() {
            return this.thingTypes != null ? (Collection)this.thingTypes.stream().map(ThingTypeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder thingTypes(Collection<ThingTypeDefinition> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copy(thingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingTypes(ThingTypeDefinition ... thingTypes) {
            this.thingTypes(Arrays.asList(thingTypes));
            return this;
        }

        public final void setThingTypes(Collection<ThingTypeDefinition.BuilderImpl> thingTypes) {
            this.thingTypes = ThingTypeListCopier.copyFromBuilder(thingTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListThingTypesResponse build() {
            return new ListThingTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListThingTypesResponse> {
        public Builder thingTypes(Collection<ThingTypeDefinition> var1);

        public Builder thingTypes(ThingTypeDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

