/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListThingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListThingsRequest> {
    private final String nextToken;
    private final Integer maxResults;
    private final String attributeName;
    private final String attributeValue;
    private final String thingTypeName;

    private ListThingsRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.thingTypeName = builder.thingTypeName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.attributeValue() == null ? 0 : this.attributeValue().hashCode());
        hashCode = 31 * hashCode + (this.thingTypeName() == null ? 0 : this.thingTypeName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsRequest)) {
            return false;
        }
        ListThingsRequest other = (ListThingsRequest)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValue() == null ^ this.attributeValue() == null) {
            return false;
        }
        if (other.attributeValue() != null && !other.attributeValue().equals(this.attributeValue())) {
            return false;
        }
        if (other.thingTypeName() == null ^ this.thingTypeName() == null) {
            return false;
        }
        return other.thingTypeName() == null || other.thingTypeName().equals(this.thingTypeName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValue() != null) {
            sb.append("AttributeValue: ").append(this.attributeValue()).append(",");
        }
        if (this.thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(this.thingTypeName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "attributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "attributeValue": {
                return Optional.of(clazz.cast(this.attributeValue()));
            }
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String attributeName;
        private String attributeValue;
        private String thingTypeName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsRequest model) {
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
            this.thingTypeName(model.thingTypeName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public ListThingsRequest build() {
            return new ListThingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListThingsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);

        public Builder thingTypeName(String var1);
    }
}

