/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.iot.model.TopicRuleListCopier;
import software.amazon.awssdk.services.iot.model.TopicRuleListItem;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTopicRulesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTopicRulesResponse> {
    private final List<TopicRuleListItem> rules;
    private final String nextToken;

    private ListTopicRulesResponse(BuilderImpl builder) {
        this.rules = builder.rules;
        this.nextToken = builder.nextToken;
    }

    public List<TopicRuleListItem> rules() {
        return this.rules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesResponse)) {
            return false;
        }
        ListTopicRulesResponse other = (ListTopicRulesResponse)((Object)obj);
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TopicRuleListItem> rules;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRulesResponse model) {
            this.rules(model.rules);
            this.nextToken(model.nextToken);
        }

        public final Collection<TopicRuleListItem.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(TopicRuleListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<TopicRuleListItem> rules) {
            this.rules = TopicRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(TopicRuleListItem ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<TopicRuleListItem.BuilderImpl> rules) {
            this.rules = TopicRuleListCopier.copyFromBuilder(rules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListTopicRulesResponse build() {
            return new ListTopicRulesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTopicRulesResponse> {
        public Builder rules(Collection<TopicRuleListItem> var1);

        public Builder rules(TopicRuleListItem ... var1);

        public Builder nextToken(String var1);
    }
}

