/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SqsActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SqsAction
implements StructuredPojo,
ToCopyableBuilder<Builder, SqsAction> {
    private final String roleArn;
    private final String queueUrl;
    private final Boolean useBase64;

    private SqsAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.queueUrl = builder.queueUrl;
        this.useBase64 = builder.useBase64;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public Boolean useBase64() {
        return this.useBase64;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.useBase64() == null ? 0 : this.useBase64().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqsAction)) {
            return false;
        }
        SqsAction other = (SqsAction)obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.useBase64() == null ^ this.useBase64() == null) {
            return false;
        }
        return other.useBase64() == null || other.useBase64().equals(this.useBase64());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.useBase64() != null) {
            sb.append("UseBase64: ").append(this.useBase64()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "queueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "useBase64": {
                return Optional.of(clazz.cast(this.useBase64()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SqsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String queueUrl;
        private Boolean useBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(SqsAction model) {
            this.roleArn(model.roleArn);
            this.queueUrl(model.queueUrl);
            this.useBase64(model.useBase64);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Boolean getUseBase64() {
            return this.useBase64;
        }

        @Override
        public final Builder useBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
            return this;
        }

        public final void setUseBase64(Boolean useBase64) {
            this.useBase64 = useBase64;
        }

        public SqsAction build() {
            return new SqsAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SqsAction> {
        public Builder roleArn(String var1);

        public Builder queueUrl(String var1);

        public Builder useBase64(Boolean var1);
    }
}

