/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.SearchableAttributesCopier;
import software.amazon.awssdk.services.iot.transform.ThingTypePropertiesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ThingTypeProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingTypeProperties> {
    private final String thingTypeDescription;
    private final List<String> searchableAttributes;

    private ThingTypeProperties(BuilderImpl builder) {
        this.thingTypeDescription = builder.thingTypeDescription;
        this.searchableAttributes = builder.searchableAttributes;
    }

    public String thingTypeDescription() {
        return this.thingTypeDescription;
    }

    public List<String> searchableAttributes() {
        return this.searchableAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.thingTypeDescription() == null ? 0 : this.thingTypeDescription().hashCode());
        hashCode = 31 * hashCode + (this.searchableAttributes() == null ? 0 : this.searchableAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeProperties)) {
            return false;
        }
        ThingTypeProperties other = (ThingTypeProperties)obj;
        if (other.thingTypeDescription() == null ^ this.thingTypeDescription() == null) {
            return false;
        }
        if (other.thingTypeDescription() != null && !other.thingTypeDescription().equals(this.thingTypeDescription())) {
            return false;
        }
        if (other.searchableAttributes() == null ^ this.searchableAttributes() == null) {
            return false;
        }
        return other.searchableAttributes() == null || other.searchableAttributes().equals(this.searchableAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.thingTypeDescription() != null) {
            sb.append("ThingTypeDescription: ").append(this.thingTypeDescription()).append(",");
        }
        if (this.searchableAttributes() != null) {
            sb.append("SearchableAttributes: ").append(this.searchableAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeDescription": {
                return Optional.of(clazz.cast(this.thingTypeDescription()));
            }
            case "searchableAttributes": {
                return Optional.of(clazz.cast(this.searchableAttributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingTypeDescription;
        private List<String> searchableAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeProperties model) {
            this.thingTypeDescription(model.thingTypeDescription);
            this.searchableAttributes(model.searchableAttributes);
        }

        public final String getThingTypeDescription() {
            return this.thingTypeDescription;
        }

        @Override
        public final Builder thingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
            return this;
        }

        public final void setThingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
        }

        public final Collection<String> getSearchableAttributes() {
            return this.searchableAttributes;
        }

        @Override
        public final Builder searchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchableAttributes(String ... searchableAttributes) {
            this.searchableAttributes(Arrays.asList(searchableAttributes));
            return this;
        }

        public final void setSearchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
        }

        public ThingTypeProperties build() {
            return new ThingTypeProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingTypeProperties> {
        public Builder thingTypeDescription(String var1);

        public Builder searchableAttributes(Collection<String> var1);

        public Builder searchableAttributes(String ... var1);
    }
}

