/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateCACertificateRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateCACertificateRequest> {
    private final String certificateId;
    private final String newStatus;
    private final String newAutoRegistrationStatus;

    private UpdateCACertificateRequest(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
        this.newAutoRegistrationStatus = builder.newAutoRegistrationStatus;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus newStatus() {
        return CACertificateStatus.fromValue(this.newStatus);
    }

    public String newStatusString() {
        return this.newStatus;
    }

    public AutoRegistrationStatus newAutoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.newAutoRegistrationStatus);
    }

    public String newAutoRegistrationStatusString() {
        return this.newAutoRegistrationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateId() == null ? 0 : this.certificateId().hashCode());
        hashCode = 31 * hashCode + (this.newStatusString() == null ? 0 : this.newStatusString().hashCode());
        hashCode = 31 * hashCode + (this.newAutoRegistrationStatusString() == null ? 0 : this.newAutoRegistrationStatusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCACertificateRequest)) {
            return false;
        }
        UpdateCACertificateRequest other = (UpdateCACertificateRequest)((Object)obj);
        if (other.certificateId() == null ^ this.certificateId() == null) {
            return false;
        }
        if (other.certificateId() != null && !other.certificateId().equals(this.certificateId())) {
            return false;
        }
        if (other.newStatusString() == null ^ this.newStatusString() == null) {
            return false;
        }
        if (other.newStatusString() != null && !other.newStatusString().equals(this.newStatusString())) {
            return false;
        }
        if (other.newAutoRegistrationStatusString() == null ^ this.newAutoRegistrationStatusString() == null) {
            return false;
        }
        return other.newAutoRegistrationStatusString() == null || other.newAutoRegistrationStatusString().equals(this.newAutoRegistrationStatusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.certificateId() != null) {
            sb.append("CertificateId: ").append(this.certificateId()).append(",");
        }
        if (this.newStatusString() != null) {
            sb.append("NewStatus: ").append(this.newStatusString()).append(",");
        }
        if (this.newAutoRegistrationStatusString() != null) {
            sb.append("NewAutoRegistrationStatus: ").append(this.newAutoRegistrationStatusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "newStatus": {
                return Optional.of(clazz.cast(this.newStatusString()));
            }
            case "newAutoRegistrationStatus": {
                return Optional.of(clazz.cast(this.newAutoRegistrationStatusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private String newStatus;
        private String newAutoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCACertificateRequest model) {
            this.certificateId(model.certificateId);
            this.newStatus(model.newStatus);
            this.newAutoRegistrationStatus(model.newAutoRegistrationStatus);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatus() {
            return this.newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        public final String getNewAutoRegistrationStatus() {
            return this.newAutoRegistrationStatus;
        }

        @Override
        public final Builder newAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus.toString());
            return this;
        }

        public final void setNewAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
        }

        public UpdateCACertificateRequest build() {
            return new UpdateCACertificateRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateCACertificateRequest> {
        public Builder certificateId(String var1);

        public Builder newStatus(String var1);

        public Builder newStatus(CACertificateStatus var1);

        public Builder newAutoRegistrationStatus(String var1);

        public Builder newAutoRegistrationStatus(AutoRegistrationStatus var1);
    }
}

