/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CloudwatchMetricAction;

@SdkInternalApi
public class CloudwatchMetricActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> METRICNAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricNamespace").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").build();
    private static final MarshallingInfo<String> METRICVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricValue").build();
    private static final MarshallingInfo<String> METRICUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricUnit").build();
    private static final MarshallingInfo<String> METRICTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricTimestamp").build();
    private static final CloudwatchMetricActionMarshaller INSTANCE = new CloudwatchMetricActionMarshaller();

    public static CloudwatchMetricActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudwatchMetricAction cloudwatchMetricAction, ProtocolMarshaller protocolMarshaller) {
        if (cloudwatchMetricAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricNamespace(), METRICNAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricValue(), METRICVALUE_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricUnit(), METRICUNIT_BINDING);
            protocolMarshaller.marshall((Object)cloudwatchMetricAction.metricTimestamp(), METRICTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

