/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ElasticsearchAction;

@SdkInternalApi
public class ElasticsearchActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoint").build();
    private static final MarshallingInfo<String> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("index").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final ElasticsearchActionMarshaller INSTANCE = new ElasticsearchActionMarshaller();

    public static ElasticsearchActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchAction elasticsearchAction, ProtocolMarshaller protocolMarshaller) {
        if (elasticsearchAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)elasticsearchAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.index(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.id(), ID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

