/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateKeysAndCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateKeysAndCertificateResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateKeysAndCertificateResponse.Builder, CreateKeysAndCertificateResponse> {
    private final String certificateArn;

    private final String certificateId;

    private final String certificatePem;

    private final KeyPair keyPair;

    private CreateKeysAndCertificateResponse(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
        this.keyPair = builder.keyPair;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS IoT
     * Certificate).
     * </p>
     * 
     * @return The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS
     *         IoT Certificate).
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The generated key pair.
     * </p>
     * 
     * @return The generated key pair.
     */
    public KeyPair keyPair() {
        return keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeysAndCertificateResponse)) {
            return false;
        }
        CreateKeysAndCertificateResponse other = (CreateKeysAndCertificateResponse) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(keyPair(), other.keyPair());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificateArn() != null) {
            sb.append("CertificateArn: ").append(certificateArn()).append(",");
        }
        if (certificateId() != null) {
            sb.append("CertificateId: ").append(certificateId()).append(",");
        }
        if (certificatePem() != null) {
            sb.append("CertificatePem: ").append(certificatePem()).append(",");
        }
        if (keyPair() != null) {
            sb.append("KeyPair: ").append(keyPair()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.of(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        case "certificatePem":
            return Optional.of(clazz.cast(certificatePem()));
        case "keyPair":
            return Optional.of(clazz.cast(keyPair()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateKeysAndCertificateResponse> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS IoT
         * Certificate).
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate. AWS IoT issues a default subject name for the certificate (for example, AWS
         *        IoT Certificate).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The generated key pair.
         * </p>
         * 
         * @param keyPair
         *        The generated key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);

        /**
         * <p>
         * The generated key pair.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyPair.Builder} avoiding the need to create one
         * manually via {@link KeyPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPair.Builder#build()} is called immediately and its result is
         * passed to {@link #keyPair(KeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link KeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(KeyPair)
         */
        default Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return keyPair(KeyPair.builder().apply(keyPair).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String certificatePem;

        private KeyPair keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeysAndCertificateResponse model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            certificatePem(model.certificatePem);
            keyPair(model.keyPair);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        public CreateKeysAndCertificateResponse build() {
            return new CreateKeysAndCertificateResponse(this);
        }
    }
}
