/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateThingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateThingRequest.Builder, CreateThingRequest> {
    private final String thingName;

    private final String thingTypeName;

    private final AttributePayload attributePayload;

    private CreateThingRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
    }

    /**
     * <p>
     * The name of the thing to create.
     * </p>
     * 
     * @return The name of the thing to create.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The name of the thing type associated with the new thing.
     * </p>
     * 
     * @return The name of the thing type associated with the new thing.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
     * </p>
     * <p>
     * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     * </p>
     * 
     * @return The attribute payload, which consists of up to three name/value pairs in a JSON document. For
     *         example:</p>
     *         <p>
     *         <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
     */
    public AttributePayload attributePayload() {
        return attributePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributePayload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingRequest)) {
            return false;
        }
        CreateThingRequest other = (CreateThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(attributePayload(), other.attributePayload());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (attributePayload() != null) {
            sb.append("AttributePayload: ").append(attributePayload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.of(clazz.cast(thingName()));
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "attributePayload":
            return Optional.of(clazz.cast(attributePayload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateThingRequest> {
        /**
         * <p>
         * The name of the thing to create.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The name of the thing type associated with the new thing.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type associated with the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * </p>
         * 
         * @param attributePayload
         *        The attribute payload, which consists of up to three name/value pairs in a JSON document. For
         *        example:</p>
         *        <p>
         *        <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePayload(AttributePayload attributePayload);

        /**
         * <p>
         * The attribute payload, which consists of up to three name/value pairs in a JSON document. For example:
         * </p>
         * <p>
         * <code>{\"attributes\":{\"string1\":\"string2\"}}</code>
         * </p>
         * This is a convenience that creates an instance of the {@link AttributePayload.Builder} avoiding the need to
         * create one manually via {@link AttributePayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributePayload.Builder#build()} is called immediately and its
         * result is passed to {@link #attributePayload(AttributePayload)}.
         * 
         * @param attributePayload
         *        a consumer that will call methods on {@link AttributePayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributePayload(AttributePayload)
         */
        default Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return attributePayload(AttributePayload.builder().apply(attributePayload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingTypeName;

        private AttributePayload attributePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingRequest model) {
            thingName(model.thingName);
            thingTypeName(model.thingTypeName);
            attributePayload(model.attributePayload);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return attributePayload != null ? attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        @Override
        public CreateThingRequest build() {
            return new CreateThingRequest(this);
        }
    }
}
