/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KinesisActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write data to an Amazon Kinesis stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KinesisAction implements StructuredPojo, ToCopyableBuilder<KinesisAction.Builder, KinesisAction> {
    private final String roleArn;

    private final String streamName;

    private final String partitionKey;

    private KinesisAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.streamName = builder.streamName;
        this.partitionKey = builder.partitionKey;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the Amazon Kinesis stream.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The partition key.
     * </p>
     * 
     * @return The partition key.
     */
    public String partitionKey() {
        return partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(partitionKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisAction)) {
            return false;
        }
        KinesisAction other = (KinesisAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(partitionKey(), other.partitionKey());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (partitionKey() != null) {
            sb.append("PartitionKey: ").append(partitionKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "streamName":
            return Optional.of(clazz.cast(streamName()));
        case "partitionKey":
            return Optional.of(clazz.cast(partitionKey()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the Amazon Kinesis stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The partition key.
         * </p>
         * 
         * @param partitionKey
         *        The partition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(String partitionKey);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String streamName;

        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisAction model) {
            roleArn(model.roleArn);
            streamName(model.streamName);
            partitionKey(model.partitionKey);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getPartitionKey() {
            return partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public KinesisAction build() {
            return new KinesisAction(this);
        }
    }
}
