/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListCACertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCACertificatesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCACertificatesResponse.Builder, ListCACertificatesResponse> {
    private final List<CACertificate> certificates;

    private final String nextMarker;

    private ListCACertificatesResponse(BuilderImpl builder) {
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The CA certificates registered in your AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The CA certificates registered in your AWS account.
     */
    public List<CACertificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * The current position within the list of CA certificates.
     * </p>
     * 
     * @return The current position within the list of CA certificates.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCACertificatesResponse)) {
            return false;
        }
        ListCACertificatesResponse other = (ListCACertificatesResponse) obj;
        return Objects.equals(certificates(), other.certificates()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificates() != null) {
            sb.append("Certificates: ").append(certificates()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificates":
            return Optional.of(clazz.cast(certificates()));
        case "nextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCACertificatesResponse> {
        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<CACertificate> certificates);

        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(CACertificate... certificates);

        /**
         * <p>
         * The current position within the list of CA certificates.
         * </p>
         * 
         * @param nextMarker
         *        The current position within the list of CA certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl implements Builder {
        private List<CACertificate> certificates;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCACertificatesResponse model) {
            certificates(model.certificates);
            nextMarker(model.nextMarker);
        }

        public final Collection<CACertificate.Builder> getCertificates() {
            return certificates != null ? certificates.stream().map(CACertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CACertificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        public final void setCertificates(Collection<CACertificate.BuilderImpl> certificates) {
            this.certificates = CACertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCACertificatesResponse build() {
            return new ListCACertificatesResponse(this);
        }
    }
}
