/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CloudwatchMetricActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudwatchMetricAction
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudwatchMetricAction> {
    private final String roleArn;
    private final String metricNamespace;
    private final String metricName;
    private final String metricValue;
    private final String metricUnit;
    private final String metricTimestamp;

    private CloudwatchMetricAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricValue = builder.metricValue;
        this.metricUnit = builder.metricUnit;
        this.metricTimestamp = builder.metricTimestamp;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public String metricValue() {
        return this.metricValue;
    }

    public String metricUnit() {
        return this.metricUnit;
    }

    public String metricTimestamp() {
        return this.metricTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchMetricAction)) {
            return false;
        }
        CloudwatchMetricAction other = (CloudwatchMetricAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.metricNamespace(), other.metricNamespace()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.metricUnit(), other.metricUnit()) && Objects.equals(this.metricTimestamp(), other.metricTimestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.metricNamespace() != null) {
            sb.append("MetricNamespace: ").append(this.metricNamespace()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.metricValue() != null) {
            sb.append("MetricValue: ").append(this.metricValue()).append(",");
        }
        if (this.metricUnit() != null) {
            sb.append("MetricUnit: ").append(this.metricUnit()).append(",");
        }
        if (this.metricTimestamp() != null) {
            sb.append("MetricTimestamp: ").append(this.metricTimestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "metricNamespace": {
                return Optional.of(clazz.cast(this.metricNamespace()));
            }
            case "metricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "metricValue": {
                return Optional.of(clazz.cast(this.metricValue()));
            }
            case "metricUnit": {
                return Optional.of(clazz.cast(this.metricUnit()));
            }
            case "metricTimestamp": {
                return Optional.of(clazz.cast(this.metricTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudwatchMetricActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String metricNamespace;
        private String metricName;
        private String metricValue;
        private String metricUnit;
        private String metricTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchMetricAction model) {
            this.roleArn(model.roleArn);
            this.metricNamespace(model.metricNamespace);
            this.metricName(model.metricName);
            this.metricValue(model.metricValue);
            this.metricUnit(model.metricUnit);
            this.metricTimestamp(model.metricTimestamp);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final String getMetricUnit() {
            return this.metricUnit;
        }

        @Override
        public final Builder metricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
            return this;
        }

        public final void setMetricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
        }

        public final String getMetricTimestamp() {
            return this.metricTimestamp;
        }

        @Override
        public final Builder metricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
            return this;
        }

        public final void setMetricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
        }

        public CloudwatchMetricAction build() {
            return new CloudwatchMetricAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudwatchMetricAction> {
        public Builder roleArn(String var1);

        public Builder metricNamespace(String var1);

        public Builder metricName(String var1);

        public Builder metricValue(String var1);

        public Builder metricUnit(String var1);

        public Builder metricTimestamp(String var1);
    }
}

