/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteThingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteThingRequest> {
    private final String thingName;
    private final Long expectedVersion;

    private DeleteThingRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.expectedVersion = builder.expectedVersion;
    }

    public String thingName() {
        return this.thingName;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThingRequest)) {
            return false;
        }
        DeleteThingRequest other = (DeleteThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.expectedVersion(), other.expectedVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.thingName() != null) {
            sb.append("ThingName: ").append(this.thingName()).append(",");
        }
        if (this.expectedVersion() != null) {
            sb.append("ExpectedVersion: ").append(this.expectedVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
            case "expectedVersion": {
                return Optional.of(clazz.cast(this.expectedVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThingRequest model) {
            this.thingName(model.thingName);
            this.expectedVersion(model.expectedVersion);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public DeleteThingRequest build() {
            return new DeleteThingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteThingRequest> {
        public Builder thingName(String var1);

        public Builder expectedVersion(Long var1);
    }
}

