/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.DynamoKeyType;
import software.amazon.awssdk.services.iot.transform.DynamoDBActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DynamoDBAction
implements StructuredPojo,
ToCopyableBuilder<Builder, DynamoDBAction> {
    private final String tableName;
    private final String roleArn;
    private final String operation;
    private final String hashKeyField;
    private final String hashKeyValue;
    private final String hashKeyType;
    private final String rangeKeyField;
    private final String rangeKeyValue;
    private final String rangeKeyType;
    private final String payloadField;

    private DynamoDBAction(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.operation = builder.operation;
        this.hashKeyField = builder.hashKeyField;
        this.hashKeyValue = builder.hashKeyValue;
        this.hashKeyType = builder.hashKeyType;
        this.rangeKeyField = builder.rangeKeyField;
        this.rangeKeyValue = builder.rangeKeyValue;
        this.rangeKeyType = builder.rangeKeyType;
        this.payloadField = builder.payloadField;
    }

    public String tableName() {
        return this.tableName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String operation() {
        return this.operation;
    }

    public String hashKeyField() {
        return this.hashKeyField;
    }

    public String hashKeyValue() {
        return this.hashKeyValue;
    }

    public DynamoKeyType hashKeyType() {
        return DynamoKeyType.fromValue(this.hashKeyType);
    }

    public String hashKeyTypeString() {
        return this.hashKeyType;
    }

    public String rangeKeyField() {
        return this.rangeKeyField;
    }

    public String rangeKeyValue() {
        return this.rangeKeyValue;
    }

    public DynamoKeyType rangeKeyType() {
        return DynamoKeyType.fromValue(this.rangeKeyType);
    }

    public String rangeKeyTypeString() {
        return this.rangeKeyType;
    }

    public String payloadField() {
        return this.payloadField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadField());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBAction)) {
            return false;
        }
        DynamoDBAction other = (DynamoDBAction)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.hashKeyField(), other.hashKeyField()) && Objects.equals(this.hashKeyValue(), other.hashKeyValue()) && Objects.equals(this.hashKeyTypeString(), other.hashKeyTypeString()) && Objects.equals(this.rangeKeyField(), other.rangeKeyField()) && Objects.equals(this.rangeKeyValue(), other.rangeKeyValue()) && Objects.equals(this.rangeKeyTypeString(), other.rangeKeyTypeString()) && Objects.equals(this.payloadField(), other.payloadField());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.operation() != null) {
            sb.append("Operation: ").append(this.operation()).append(",");
        }
        if (this.hashKeyField() != null) {
            sb.append("HashKeyField: ").append(this.hashKeyField()).append(",");
        }
        if (this.hashKeyValue() != null) {
            sb.append("HashKeyValue: ").append(this.hashKeyValue()).append(",");
        }
        if (this.hashKeyTypeString() != null) {
            sb.append("HashKeyType: ").append(this.hashKeyTypeString()).append(",");
        }
        if (this.rangeKeyField() != null) {
            sb.append("RangeKeyField: ").append(this.rangeKeyField()).append(",");
        }
        if (this.rangeKeyValue() != null) {
            sb.append("RangeKeyValue: ").append(this.rangeKeyValue()).append(",");
        }
        if (this.rangeKeyTypeString() != null) {
            sb.append("RangeKeyType: ").append(this.rangeKeyTypeString()).append(",");
        }
        if (this.payloadField() != null) {
            sb.append("PayloadField: ").append(this.payloadField()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "operation": {
                return Optional.of(clazz.cast(this.operation()));
            }
            case "hashKeyField": {
                return Optional.of(clazz.cast(this.hashKeyField()));
            }
            case "hashKeyValue": {
                return Optional.of(clazz.cast(this.hashKeyValue()));
            }
            case "hashKeyType": {
                return Optional.of(clazz.cast(this.hashKeyTypeString()));
            }
            case "rangeKeyField": {
                return Optional.of(clazz.cast(this.rangeKeyField()));
            }
            case "rangeKeyValue": {
                return Optional.of(clazz.cast(this.rangeKeyValue()));
            }
            case "rangeKeyType": {
                return Optional.of(clazz.cast(this.rangeKeyTypeString()));
            }
            case "payloadField": {
                return Optional.of(clazz.cast(this.payloadField()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DynamoDBActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String roleArn;
        private String operation;
        private String hashKeyField;
        private String hashKeyValue;
        private String hashKeyType;
        private String rangeKeyField;
        private String rangeKeyValue;
        private String rangeKeyType;
        private String payloadField;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBAction model) {
            this.tableName(model.tableName);
            this.roleArn(model.roleArn);
            this.operation(model.operation);
            this.hashKeyField(model.hashKeyField);
            this.hashKeyValue(model.hashKeyValue);
            this.hashKeyType(model.hashKeyType);
            this.rangeKeyField(model.rangeKeyField);
            this.rangeKeyValue(model.rangeKeyValue);
            this.rangeKeyType(model.rangeKeyType);
            this.payloadField(model.payloadField);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getHashKeyField() {
            return this.hashKeyField;
        }

        @Override
        public final Builder hashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
            return this;
        }

        public final void setHashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
        }

        public final String getHashKeyValue() {
            return this.hashKeyValue;
        }

        @Override
        public final Builder hashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        public final void setHashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
        }

        public final String getHashKeyType() {
            return this.hashKeyType;
        }

        @Override
        public final Builder hashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
            return this;
        }

        @Override
        public final Builder hashKeyType(DynamoKeyType hashKeyType) {
            this.hashKeyType(hashKeyType.toString());
            return this;
        }

        public final void setHashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
        }

        public final String getRangeKeyField() {
            return this.rangeKeyField;
        }

        @Override
        public final Builder rangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
            return this;
        }

        public final void setRangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
        }

        public final String getRangeKeyValue() {
            return this.rangeKeyValue;
        }

        @Override
        public final Builder rangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        public final void setRangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
        }

        public final String getRangeKeyType() {
            return this.rangeKeyType;
        }

        @Override
        public final Builder rangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
            return this;
        }

        @Override
        public final Builder rangeKeyType(DynamoKeyType rangeKeyType) {
            this.rangeKeyType(rangeKeyType.toString());
            return this;
        }

        public final void setRangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
        }

        public final String getPayloadField() {
            return this.payloadField;
        }

        @Override
        public final Builder payloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public final void setPayloadField(String payloadField) {
            this.payloadField = payloadField;
        }

        public DynamoDBAction build() {
            return new DynamoDBAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DynamoDBAction> {
        public Builder tableName(String var1);

        public Builder roleArn(String var1);

        public Builder operation(String var1);

        public Builder hashKeyField(String var1);

        public Builder hashKeyValue(String var1);

        public Builder hashKeyType(String var1);

        public Builder hashKeyType(DynamoKeyType var1);

        public Builder rangeKeyField(String var1);

        public Builder rangeKeyValue(String var1);

        public Builder rangeKeyType(String var1);

        public Builder rangeKeyType(DynamoKeyType var1);

        public Builder payloadField(String var1);
    }
}

