/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ElasticsearchActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchAction
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchAction> {
    private final String roleArn;
    private final String endpoint;
    private final String index;
    private final String type;
    private final String id;

    private ElasticsearchAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.endpoint = builder.endpoint;
        this.index = builder.index;
        this.type = builder.type;
        this.id = builder.id;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchAction)) {
            return false;
        }
        ElasticsearchAction other = (ElasticsearchAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.index(), other.index()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.index() != null) {
            sb.append("Index: ").append(this.index()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "index": {
                return Optional.of(clazz.cast(this.index()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String endpoint;
        private String index;
        private String type;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchAction model) {
            this.roleArn(model.roleArn);
            this.endpoint(model.endpoint);
            this.index(model.index);
            this.type(model.type);
            this.id(model.id);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public ElasticsearchAction build() {
            return new ElasticsearchAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchAction> {
        public Builder roleArn(String var1);

        public Builder endpoint(String var1);

        public Builder index(String var1);

        public Builder type(String var1);

        public Builder id(String var1);
    }
}

