/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetPolicyResponse> {
    private final String policyName;
    private final String policyArn;
    private final String policyDocument;
    private final String defaultVersionId;

    private GetPolicyResponse(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.defaultVersionId = builder.defaultVersionId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.policyArn() != null) {
            sb.append("PolicyArn: ").append(this.policyArn()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.defaultVersionId() != null) {
            sb.append("DefaultVersionId: ").append(this.defaultVersionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "policyArn": {
                return Optional.of(clazz.cast(this.policyArn()));
            }
            case "policyDocument": {
                return Optional.of(clazz.cast(this.policyDocument()));
            }
            case "defaultVersionId": {
                return Optional.of(clazz.cast(this.defaultVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyArn;
        private String policyDocument;
        private String defaultVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            this.policyName(model.policyName);
            this.policyArn(model.policyArn);
            this.policyDocument(model.policyDocument);
            this.defaultVersionId(model.defaultVersionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetPolicyResponse> {
        public Builder policyName(String var1);

        public Builder policyArn(String var1);

        public Builder policyDocument(String var1);

        public Builder defaultVersionId(String var1);
    }
}

