/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCACertificatesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListCACertificatesRequest> {
    private final Integer pageSize;
    private final String marker;
    private final Boolean ascendingOrder;

    private ListCACertificatesRequest(BuilderImpl builder) {
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean ascendingOrder() {
        return this.ascendingOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascendingOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCACertificatesRequest)) {
            return false;
        }
        ListCACertificatesRequest other = (ListCACertificatesRequest)((Object)obj);
        return Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.ascendingOrder(), other.ascendingOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.ascendingOrder() != null) {
            sb.append("AscendingOrder: ").append(this.ascendingOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ascendingOrder": {
                return Optional.of(clazz.cast(this.ascendingOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer pageSize;
        private String marker;
        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCACertificatesRequest model) {
            this.pageSize(model.pageSize);
            this.marker(model.marker);
            this.ascendingOrder(model.ascendingOrder);
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return this.ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        public ListCACertificatesRequest build() {
            return new ListCACertificatesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCACertificatesRequest> {
        public Builder pageSize(Integer var1);

        public Builder marker(String var1);

        public Builder ascendingOrder(Boolean var1);
    }
}

