/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.services.iot.transform.LoggingOptionsPayloadMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoggingOptionsPayload
implements StructuredPojo,
ToCopyableBuilder<Builder, LoggingOptionsPayload> {
    private final String roleArn;
    private final String logLevel;

    private LoggingOptionsPayload(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.logLevel = builder.logLevel;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptionsPayload)) {
            return false;
        }
        LoggingOptionsPayload other = (LoggingOptionsPayload)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.logLevelString(), other.logLevelString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.logLevelString() != null) {
            sb.append("LogLevel: ").append(this.logLevelString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "logLevel": {
                return Optional.of(clazz.cast(this.logLevelString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingOptionsPayloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingOptionsPayload model) {
            this.roleArn(model.roleArn);
            this.logLevel(model.logLevel);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public LoggingOptionsPayload build() {
            return new LoggingOptionsPayload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoggingOptionsPayload> {
        public Builder roleArn(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

