/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.MessageFormat;
import software.amazon.awssdk.services.iot.transform.SnsActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SnsAction
implements StructuredPojo,
ToCopyableBuilder<Builder, SnsAction> {
    private final String targetArn;
    private final String roleArn;
    private final String messageFormat;

    private SnsAction(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.messageFormat = builder.messageFormat;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public MessageFormat messageFormat() {
        return MessageFormat.fromValue(this.messageFormat);
    }

    public String messageFormatString() {
        return this.messageFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction)obj;
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.messageFormatString(), other.messageFormatString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetArn() != null) {
            sb.append("TargetArn: ").append(this.targetArn()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.messageFormatString() != null) {
            sb.append("MessageFormat: ").append(this.messageFormatString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.of(clazz.cast(this.targetArn()));
            }
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "messageFormat": {
                return Optional.of(clazz.cast(this.messageFormatString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetArn;
        private String roleArn;
        private String messageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            this.targetArn(model.targetArn);
            this.roleArn(model.roleArn);
            this.messageFormat(model.messageFormat);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public SnsAction build() {
            return new SnsAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SnsAction> {
        public Builder targetArn(String var1);

        public Builder roleArn(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormat var1);
    }
}

