/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.ThingTypeMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ThingTypeMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ThingTypeMetadata> {
    private final Boolean deprecated;
    private final Instant deprecationDate;
    private final Instant creationDate;

    private ThingTypeMetadata(BuilderImpl builder) {
        this.deprecated = builder.deprecated;
        this.deprecationDate = builder.deprecationDate;
        this.creationDate = builder.creationDate;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public Instant deprecationDate() {
        return this.deprecationDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecated());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeMetadata)) {
            return false;
        }
        ThingTypeMetadata other = (ThingTypeMetadata)obj;
        return Objects.equals(this.deprecated(), other.deprecated()) && Objects.equals(this.deprecationDate(), other.deprecationDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deprecated() != null) {
            sb.append("Deprecated: ").append(this.deprecated()).append(",");
        }
        if (this.deprecationDate() != null) {
            sb.append("DeprecationDate: ").append(this.deprecationDate()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deprecated": {
                return Optional.of(clazz.cast(this.deprecated()));
            }
            case "deprecationDate": {
                return Optional.of(clazz.cast(this.deprecationDate()));
            }
            case "creationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThingTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean deprecated;
        private Instant deprecationDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeMetadata model) {
            this.deprecated(model.deprecated);
            this.deprecationDate(model.deprecationDate);
            this.creationDate(model.creationDate);
        }

        public final Boolean getDeprecated() {
            return this.deprecated;
        }

        @Override
        public final Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public final void setDeprecated(Boolean deprecated) {
            this.deprecated = deprecated;
        }

        public final Instant getDeprecationDate() {
            return this.deprecationDate;
        }

        @Override
        public final Builder deprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
            return this;
        }

        public final void setDeprecationDate(Instant deprecationDate) {
            this.deprecationDate = deprecationDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public ThingTypeMetadata build() {
            return new ThingTypeMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThingTypeMetadata> {
        public Builder deprecated(Boolean var1);

        public Builder deprecationDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

