/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Action;

@SdkInternalApi
public class ActionMarshaller {
    private static final MarshallingInfo<StructuredPojo> DYNAMODB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDB").build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBV2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDBv2").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").build();
    private static final MarshallingInfo<StructuredPojo> SNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sns").build();
    private static final MarshallingInfo<StructuredPojo> SQS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sqs").build();
    private static final MarshallingInfo<StructuredPojo> KINESIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kinesis").build();
    private static final MarshallingInfo<StructuredPojo> REPUBLISH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("republish").build();
    private static final MarshallingInfo<StructuredPojo> S3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3").build();
    private static final MarshallingInfo<StructuredPojo> FIREHOSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firehose").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHMETRIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudwatchMetric").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHALARM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cloudwatchAlarm").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elasticsearch").build();
    private static final MarshallingInfo<StructuredPojo> SALESFORCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("salesforce").build();
    private static final ActionMarshaller INSTANCE = new ActionMarshaller();

    public static ActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Action action, ProtocolMarshaller protocolMarshaller) {
        if (action == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)action.dynamoDB(), DYNAMODB_BINDING);
            protocolMarshaller.marshall((Object)action.dynamoDBv2(), DYNAMODBV2_BINDING);
            protocolMarshaller.marshall((Object)action.lambda(), LAMBDA_BINDING);
            protocolMarshaller.marshall((Object)action.sns(), SNS_BINDING);
            protocolMarshaller.marshall((Object)action.sqs(), SQS_BINDING);
            protocolMarshaller.marshall((Object)action.kinesis(), KINESIS_BINDING);
            protocolMarshaller.marshall((Object)action.republish(), REPUBLISH_BINDING);
            protocolMarshaller.marshall((Object)action.s3(), S3_BINDING);
            protocolMarshaller.marshall((Object)action.firehose(), FIREHOSE_BINDING);
            protocolMarshaller.marshall((Object)action.cloudwatchMetric(), CLOUDWATCHMETRIC_BINDING);
            protocolMarshaller.marshall((Object)action.cloudwatchAlarm(), CLOUDWATCHALARM_BINDING);
            protocolMarshaller.marshall((Object)action.elasticsearch(), ELASTICSEARCH_BINDING);
            protocolMarshaller.marshall((Object)action.salesforce(), SALESFORCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

