/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.CACertificateDescription;

@SdkInternalApi
public class CACertificateDescriptionMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").build();
    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").build();
    private static final MarshallingInfo<String> AUTOREGISTRATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoRegistrationStatus").build();
    private static final CACertificateDescriptionMarshaller INSTANCE = new CACertificateDescriptionMarshaller();

    public static CACertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CACertificateDescription caCertificateDescription, ProtocolMarshaller protocolMarshaller) {
        if (caCertificateDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)caCertificateDescription.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.ownedBy(), OWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)caCertificateDescription.autoRegistrationStatusString(), AUTOREGISTRATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

