/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PublishRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PublishRequest> {
    private final String topic;
    private final Integer qos;
    private final ByteBuffer payload;

    private PublishRequest(BuilderImpl builder) {
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.payload = builder.payload;
    }

    public String topic() {
        return this.topic;
    }

    public Integer qos() {
        return this.qos;
    }

    public ByteBuffer payload() {
        return this.payload == null ? null : this.payload.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topic() != null) {
            sb.append("Topic: ").append(this.topic()).append(",");
        }
        if (this.qos() != null) {
            sb.append("Qos: ").append(this.qos()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.of(clazz.cast(this.topic()));
            }
            case "qos": {
                return Optional.of(clazz.cast(this.qos()));
            }
            case "payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topic;
        private Integer qos;
        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            this.topic(model.topic);
            this.qos(model.qos);
            this.payload(model.payload);
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getQos() {
            return this.qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        public final ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
        }

        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PublishRequest> {
        public Builder topic(String var1);

        public Builder qos(Integer var1);

        public Builder payload(ByteBuffer var1);
    }
}

