/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateThingShadowRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateThingShadowRequest> {
    private final String thingName;
    private final ByteBuffer payload;

    private UpdateThingShadowRequest(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.payload = builder.payload;
    }

    public String thingName() {
        return this.thingName;
    }

    public ByteBuffer payload() {
        return this.payload == null ? null : this.payload.asReadOnlyBuffer();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingShadowRequest)) {
            return false;
        }
        UpdateThingShadowRequest other = (UpdateThingShadowRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.thingName() != null) {
            sb.append("ThingName: ").append(this.thingName()).append(",");
        }
        if (this.payload() != null) {
            sb.append("Payload: ").append(this.payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
            case "payload": {
                return Optional.of(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingShadowRequest model) {
            this.thingName(model.thingName);
            this.payload(model.payload);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final ByteBuffer getPayload() {
            return this.payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy((ByteBuffer)payload);
        }

        public UpdateThingShadowRequest build() {
            return new UpdateThingShadowRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateThingShadowRequest> {
        public Builder thingName(String var1);

        public Builder payload(ByteBuffer var1);
    }
}

